<!DOCTYPE html>
    <html>

    <head>
        <meta charset="utf-8" />
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Delete Record using Ajax in Laravel 8 - codeanddeploy.com</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css">
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
        <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script src="plugins/Jquery-Table-Check-All/dist/TableCheckAll.js"></script>

        <script type="text/javascript">
          $(document).ready(function() {

            $("#posts-table").TableCheckAll();

            $('#multi-delete').on('click', function() {
              var button = $(this);
              var selected = [];
              $('#posts-table .check:checked').each(function() {
                selected.push($(this).val());
              });

              Swal.fire({
                icon: 'warning',
                  title: 'Are you sure you want to delete selected record(s)?',
                  showDenyButton: false,
                  showCancelButton: true,
                  confirmButtonText: 'Yes'
              }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                  $.ajax({
                    type: 'post',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: button.data('route'),
                    data: {
                      'selected': selected
                    },
                    success: function (response, textStatus, xhr) {
                      Swal.fire({
                        icon: 'success',
                          title: response,
                          showDenyButton: false,
                          showCancelButton: false,
                          confirmButtonText: 'Yes'
                      }).then((result) => {
                        window.location='/posts'
                      });
                    }
                  });
                }
              });
            });

            $('.delete-form').on('submit', function(e) {
              e.preventDefault();
              var button = $(this);

              Swal.fire({
                icon: 'warning',
                  title: 'Are you sure you want to delete this record?',
                  showDenyButton: false,
                  showCancelButton: true,
                  confirmButtonText: 'Yes'
              }).then((result) => {
                /* Read more about isConfirmed, isDenied below */
                if (result.isConfirmed) {
                  $.ajax({
                    type: 'post',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: button.data('route'),
                    data: {
                      '_method': 'delete'
                    },
                    success: function (response, textStatus, xhr) {
                      Swal.fire({
                        icon: 'success',
                          title: response,
                          showDenyButton: false,
                          showCancelButton: false,
                          confirmButtonText: 'Yes'
                      }).then((result) => {
                        window.location='/posts'
                      });
                    }
                  });
                }
              });

            })
          });
        </script>
    </head>

    <body>
        <div class="container mt-5">
            <?php if(Session::get('success', false)): ?>
              <?php $data = Session::get('success'); ?>
              <?php if(is_array($data)): ?>
                  <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <div class="alert alert-success" role="alert">
                          <i class="fa fa-check"></i>
                          <?php echo e($msg); ?>

                      </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
                  <div class="alert alert-success" role="alert">
                      <i class="fa fa-check"></i>
                      <?php echo e($data); ?>

                  </div>
              <?php endif; ?>
            <?php endif; ?>

            <button class="btn btn-danger" id="multi-delete" data-route="<?php echo e(route('posts.multi-delete')); ?>">Delete All Selected</button>

            <table class="table table-striped" id="posts-table">
              <thead>
                <tr>
                  <th scope="col"><input type="checkbox" class="check-all"></th>
                  <th scope="col">Title</th>
                  <th scope="col">Description</th>
                  <th scope="col">Body</th>
                  <th scope="col">Delete</th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><input type="checkbox" class="check" value="<?php echo e($post->id); ?>"></td>
                    <td><?php echo e($post->title); ?></td>
                    <td><?php echo e($post->description); ?></td>
                    <td><?php echo e($post->body); ?></td>
                    <td>
                        <form method="post" class="delete-form" data-route="<?php echo e(route('posts.destroy',$post->id)); ?>">
                            <?php echo method_field('delete'); ?>
                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                        </form>
                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
        </div>
    </body>
</html>
<?php /**PATH E:\projects\project 11\explorehimalayas\resources\views\livewire\main\test.blade.php ENDPATH**/ ?>