
<?php
    $modules = auth()->user()->roles[0]->modules->pluck('url')->toArray();
    $home = ['home', 'superadmin'];

    $module = ['module.index', 'module.create', 'module.show', 'module.edit'];
    $role = ['role.index', 'role.show', 'role.create', 'role.edit'];
    $user = ['user.index', 'user.show', 'user.create', 'user.index', 'user.edit'];
    $frontsetting = [
        'frontsetting.index',
        'frontsetting.show',
        'frontsetting.create',
        'frontsetting.index',
        'frontsetting.edit',
    ];
    $generaluser = [
        'generaluser.index',
        'generaluser.show',
        'generaluser.create',
        'generaluser.index',
        'generaluser.edit',
    ];
    $banner = ['banner.index', 'banner.show', 'banner.create', 'banner.index', 'banner.edit'];
    $aboutus = ['aboutus.index', 'aboutus.show', 'aboutus.create', 'aboutus.index', 'aboutus.edit'];
    $frontsetting = ['frontsetting.index', 'frontsetting.show', 'frontsetting.create', 'frontsetting.edit'];
    $categorymodule = ['categorymodule.index', 'categorymodule.show', 'categorymodule.create', 'categorymodule.edit'];

?>

<div class="sidebar" id="mySidenav">
    <a href="<?php echo e(route('home')); ?>" class="sidebar_hr_include">
        <div class="logo-details">
            <img src="<?php echo e(asset('newpanel/icons/logo.png')); ?>" alt="">
            <span class="logo_name">Admin Pannel</span>
        </div>
        <hr>
    </a>
    <ul class="nav-links">
        <li class="<?php echo e(in_array(Request::route()->getName(), $home) ? 'active' : ''); ?>">
            <a href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Dashboard</span>
            </a>

        </li>
        <li
            class="<?php echo e(in_array(Request::route()->getName(), array_merge($role, $module, $user, $generaluser)) ? 'showMenu' : ''); ?>">
            <div class="icon-link">
                <a href="#">
                    <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">

                    <span class="link_name">System Management</span>
                </a>
                <i class='bx bxs-chevron-right arrow'></i>

            </div>
            <ul class="sub-menu">


                <li class="<?php echo e(in_array(Request::route()->getName(), $role) ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('role.index')); ?>">
                        Role
                    </a>

                </li>
                <li class="<?php echo e(in_array(Request::route()->getName(), $module) ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('module.index')); ?>">
                        Module
                    </a>
                </li>

                <li class="<?php echo e(in_array(Request::route()->getName(), $user) ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('user.index')); ?>">
                        User Listing
                    </a>

                </li>
                <li class="<?php echo e(in_array(Request::route()->getName(), $generaluser) ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('generaluser.index')); ?>">
                        Customer Listing
                    </a>

                </li>

                <li class="">
                    <a href="<?php echo e(route('logout')); ?>"
                        onclick="event.preventDefault();
                    document.getElementById('logout-form').submit();">
                        LOGOUT
                    </a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                        <?php echo csrf_field(); ?>
                    </form>

                </li>
                <li class="<?php echo e(in_array(Request::route()->getName(), $module) ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('user.myedit')); ?>">
                        Edit Password
                    </a>

                </li>
            </ul>
        </li>

        <li class="<?php echo e(in_array(Request::route()->getName(), $frontsetting) ? 'active' : ''); ?>">
            <a href="<?php echo e(route('frontsetting.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">FrontSetting</span>
            </a>

        </li>
        <li class="<?php echo e(in_array(Request::route()->getName(), $categorymodule) ? 'active' : ''); ?>">
            <a href="<?php echo e(route('categorymodule.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Category</span>
            </a>

        </li>
        <li class="<?php echo e(in_array(Request::route()->getName(), $banner) ? 'active' : ''); ?>">
            <a href="<?php echo e(route('banner.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Banner</span>
            </a>

        </li>
        <li class="<?php echo e(in_array(Request::route()->getName(), $aboutus) ? 'active' : ''); ?>">
            <a href="<?php echo e(route('aboutus.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Aboutus</span>
            </a>

        </li>
        <li class="<?php echo e(Str::contains(Route::currentRouteName(), 'blog') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('blog.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Blog</span>
            </a>

        </li>
        <li class="<?php echo e(Str::contains(Route::currentRouteName(), 'faq') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('faq.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">FAQ</span>
            </a>

        </li>
        <li class="<?php echo e(Str::contains(Route::currentRouteName(), 'highlights') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('highlights.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Highlights</span>
            </a>

        </li>
        <li class="<?php echo e(Str::contains(Route::currentRouteName(), 'inquiry') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('inquiry.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Inquiry</span>
            </a>

        </li>
        <li class="<?php echo e(Str::contains(Route::currentRouteName(), 'packagemanagement') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('packagemanagement.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Packagemanagement</span>
            </a>

        </li>
        <li class="<?php echo e(Str::contains(Route::currentRouteName(), 'package') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('package.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Package</span>
            </a>

        </li>

        <li class="<?php echo e(Str::contains(Route::currentRouteName(), 'pagemodule') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('pagemodule.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Individual Page</span>
            </a>

        </li>
        <li class="<?php echo e(Str::contains(Route::currentRouteName(), 'dynamicMenu') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('dynamicMenu.mainindex')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">DynamicMenu</span>
            </a>

        </li>
        <li class="<?php echo e(Str::contains(Route::currentRouteName(), 'testimonial') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('testimonial.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Testimonial</span>
            </a>

        </li>
        <li class="<?php echo e(Str::contains(Route::currentRouteName(), 'ourteam') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('ourteam.index')); ?>">
                <img src="<?php echo e(asset('newpanel/icons/akar-icons_home.png')); ?>" alt="">
                <span class="link_name">Our Team</span>
            </a>

        </li>







    </ul>
</div>
<?php /**PATH E:\projects\project 11\explorehimalayas\resources\views\layouts\includes\sidebar.blade.php ENDPATH**/ ?>