<div>
    


    


    <div wire:ignore.defer class="modal right fade show" id="AddEntryModal" data-bs-backdrop="static" data-bs-keyboard="false"
        tabindex="-1" aria-labelledby="AddEntryModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="AddEntryModalLabel">Add Module</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" wire:click="cancel"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">


                    <form wire:submit.prevent="addSelect">
                        <input type="hidden" class="form-control" wire:model="created_by" name="created_by"
                            value="<?php echo e(Auth::user()->id); ?>">

                        <div class="row">

                            <div class="mb-3" wire:ignore>
                                <label>Parent Module</label>
                                <select class="form-control" id="FirstOption" style="width: 100%;" tabindex="-1"
                                    aria-hidden="true">
                                    <option></option>
                                    
                                </select>

                            </div>
                            


                            <div class="col-md-12 mb-3">
                                <label for="Description" class="form-label">Title</label>
                                <input type="text" class="form-control" wire:model="name" name="name"
                                    id="name" required maxlength="100">
                                <?php if($errors->has('name')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('name')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label for="date" class="form-label">Url or Route</label>
                                <input type="text" class="form-control" wire:model="url" name="url"
                                    id="url" required maxlength="300">
                                <?php if($errors->has('url')): ?>
                                    <div class="alert alert-danger">
                                        <?php echo e($errors->first('url')); ?>

                                    </div>
                                <?php endif; ?>
                            </div>


                        </div>

                        <div class="use_right">
                            <div class="mb-3" id="additionalContent">
                                <h6 class="user_permission p-0">Show to Admin</h6>

                                <div class="form-check form-check-inline">
                                    <input class="form-check-input user_radio" type="radio" wire:model="show_to_admin"
                                        name="show_to_admin" id="Active" value="1">
                                    <label class="form-check-label" for="Active">Show</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input user_radio" type="radio" wire:model="show_to_admin"
                                        name="show_to_admin" id="Inactive" value="0">
                                    <label class="form-check-label" for="Inactive">Donot Show</label>
                                </div>
                            </div>

                        </div>

                        <div class="mb-3" id="additionalContent">
                            <h6 class="user_permission p-0">Published Status</h6>

                            <div class="use_right">


                                <div class="form-check form-check-inline">
                                    <input class="form-check-input user_radio" type="radio" wire:model="status"
                                        name="status" id="Active" value="1">
                                    <label class="form-check-label" for="Active">Published</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input user_radio" type="radio" wire:model="status"
                                        name="status" id="Inactive" value="0">
                                    <label class="form-check-label" for="Inactive">Unpublished</label>
                                </div>
                            </div>
                        </div>


                        <div class="modal_btns">

                            <button type="button" class="btn upload_btn" wire:click="cancel"
                                data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn save_item">Add module </button>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>
    

    
    <div wire:ignore.self class="modal fade" id="EditEntryModal" tabindex="-1"
        aria-labelledby="EditEntryModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="EditEntryModalLabel">Update Module</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" wire:click="cancel"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <form action="" wire:submit.prevent="editData">
                        <input type="hidden" class="form-control" wire:model="updated_by" name="updated_by"
                            value="<?php echo e(Auth::user()->id); ?>">

                        <div class="row">
                            
                            <div class="col-md-12 mb-3" wire:ignore>
                                <label>Parent Module?</label>
                                <select class="form-control" id="editFirstOption"
                                    style="width: 100%;" tabindex="-1" aria-hidden="true" >
                                    
                                    
                                </select>
                                <?php if($errors->has('parent')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('parent')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label for="Description" class="form-label">Title</label>
                                <input type="text" class="form-control" name="name" wire:model="name"
                                    id="name" required maxlength="100">
                                <?php if($errors->has('name')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('name')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label for="url">URL</label>
                                <input type="text" class="form-control" name="url" wire:model="url"
                                    id="url" maxlength="300" required>
                                <?php if($errors->has('url')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('url')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>


                        </div>



                        <div class="row mt-4">
                            <div class="mb-3" id="additionalContent">
                                <h6 class="user_permission p-0">Published Status</h6>

                                <div class="use_right">


                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input user_radio" type="radio" wire:model="status"
                                            name="status" id="Active" value="1">
                                        <label class="form-check-label" for="Active">Published</label>
                                    </div>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input user_radio" type="radio" wire:model="status"
                                            name="status" id="Inactive" value="0">
                                        <label class="form-check-label" for="Inactive">Unpublished</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="use_right">
                            <div class="mb-3" id="additionalContent">
                                <h6 class="user_permission p-0">Show to Admin</h6>

                                <div class="form-check form-check-inline">
                                    <input class="form-check-input user_radio" type="radio"
                                        wire:model="show_to_admin" name="show_to_admin" id="Active"
                                        value="1" checked>
                                    <label class="form-check-label" for="Active">Show</label>
                                </div>
                                <div class="form-check form-check-inline">
                                    <input class="form-check-input user_radio" type="radio"
                                        wire:model="show_to_admin" name="show_to_admin" id="Inactive"
                                        value="0">
                                    <label class="form-check-label" for="Inactive">Donot Show</label>
                                </div>
                            </div>

                        </div>
                        <div class="modal_btns">

                            <button type="button" class="btn upload_btn" wire:click="cancel"
                                data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn save_item">Update module </button>
                        </div>
                    </form>

                </div>

            </div>
        </div>
    </div>
    

    <div class="referrel_section">
        <div class="referal_first">

            <div class="referal_title">
                <div class="page_name">
                    System Management - Module
                </div>

                <nav aria-label="breadcrumb" class="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Module</li>
                    </ol>
                </nav>
            </div>

        </div>

        <div class="referral_request_diff">

            
            <div class="project_status">
                <div class="search-container">
                    <span class="search-icon"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                            viewBox="0 0 20 20" fill="none">
                            <path
                                d="M15.5451 14.6626L17.9864 17.1026C18.1002 17.2205 18.1632 17.3784 18.1618 17.5422C18.1603 17.7061 18.0946 17.8629 17.9787 17.9787C17.8629 18.0946 17.7061 18.1603 17.5422 18.1618C17.3784 18.1632 17.2205 18.1002 17.1026 17.9864L14.6614 15.5451C13.0661 16.9119 11.0034 17.6077 8.90612 17.4865C6.80887 17.3652 4.8401 16.4364 3.41291 14.8949C1.98573 13.3534 1.21108 11.319 1.25151 9.21863C1.29194 7.11827 2.14431 5.11521 3.62976 3.62976C5.11521 2.14431 7.11827 1.29194 9.21863 1.25151C11.319 1.21108 13.3534 1.98573 14.8949 3.41291C16.4364 4.8401 17.3652 6.80887 17.4865 8.90612C17.6077 11.0034 16.9119 13.0661 15.5451 14.6614V14.6626ZM9.3751 16.2501C11.1985 16.2501 12.9471 15.5258 14.2365 14.2365C15.5258 12.9471 16.2501 11.1985 16.2501 9.3751C16.2501 7.55174 15.5258 5.80305 14.2365 4.51374C12.9471 3.22443 11.1985 2.5001 9.3751 2.5001C7.55174 2.5001 5.80305 3.22443 4.51374 4.51374C3.22443 5.80305 2.5001 7.55174 2.5001 9.3751C2.5001 11.1985 3.22443 12.9471 4.51374 14.2365C5.80305 15.5258 7.55174 16.2501 9.3751 16.2501Z"
                                fill="#5D5D5D" />
                        </svg></span>
                        <input type="search" placeholder="Search..." class="search-input"
                            wire:model.live="searchTerm">
                    
                </div>
            </div>
            <div class="right_ref">
                <div class="right_devide d-block" style="border:none;">
                    <div class="add_entry ">
                        
                        <a wire:click="openmodal">Add New <i class='bx bx-plus-circle'></i>
                        </a>
                    </div>
                </div>


            </div>
        </div>
        <div class="table_section">

            <div class="table-wrapper">

                <div class="table-responsive table_referr">

                    <table class="table">
                        <thead>
                            <tr>
                                <th>
                                    S.N.
                                </th>
                                <th>Title</th>
                                <th>Parent</th>
                                <th>Url/Route</th>
                                <th>Status</th>
                                <th>Show To Admin</th>
                                <th> Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $module_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $eachmodule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($eachmodule->id); ?>">
                                    <td><?php echo e($i + 1); ?></td>
                                    <td><?php echo e($eachmodule->name); ?></td>
                                    <td>
                                        <?php if($eachmodule->parentmodule): ?>
                                            <?php echo e($eachmodule->parentmodule->name); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($eachmodule->url); ?></td>

                                    <td>
                                        <?php if($eachmodule->status == 1): ?>
                                            <button class="grey_btn table_btn">Published </button>
                                        <?php else: ?>
                                            <button class="grey_btn table_btn">Unpublished </button>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($eachmodule->show_to_admin == 1): ?>
                                            <button class="grey_btn table_btn">Show </button>
                                        <?php else: ?>
                                            <button class="grey_btn table_btn">Donot Show </button>
                                        <?php endif; ?>
                                    </td>



                                    <td>
                                        <ul class="trash_view">
                                            
                                            <li><a data-bs-toggle="modal"
                                                    wire:click="viewDetails(<?php echo e($eachmodule->id); ?>)"
                                                    data-bs-target="#viewEntry">
                                                    <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M8.00022 9.88657C6.40688 9.88657 5.11355 8.59324 5.11355 6.99991C5.11355 5.40657 6.40688 4.11324 8.00022 4.11324C9.59355 4.11324 10.8869 5.40657 10.8869 6.99991C10.8869 8.59324 9.59355 9.88657 8.00022 9.88657ZM8.00022 5.11324C6.96022 5.11324 6.11355 5.95991 6.11355 6.99991C6.11355 8.03991 6.96022 8.88657 8.00022 8.88657C9.04021 8.88657 9.88688 8.03991 9.88688 6.99991C9.88688 5.95991 9.04021 5.11324 8.00022 5.11324Z" fill="#880505"/>
                                                        <path d="M8.00022 13.0132C5.49355 13.0132 3.12688 11.5466 1.50021 8.99991C0.793548 7.89991 0.793548 6.10657 1.50021 4.99991C3.13355 2.45324 5.50022 0.986572 8.00022 0.986572C10.5002 0.986572 12.8669 2.45324 14.4935 4.99991C15.2002 6.09991 15.2002 7.89324 14.4935 8.99991C12.8669 11.5466 10.5002 13.0132 8.00022 13.0132ZM8.00022 1.98657C5.84688 1.98657 3.78688 3.27991 2.34688 5.53991C1.84688 6.31991 1.84688 7.6799 2.34688 8.45991C3.78688 10.7199 5.84688 12.0132 8.00022 12.0132C10.1535 12.0132 12.2135 10.7199 13.6535 8.45991C14.1535 7.6799 14.1535 6.31991 13.6535 5.53991C12.2135 3.27991 10.1535 1.98657 8.00022 1.98657Z" fill="#880505"/>
                                                        </svg>
                                                </a>
                                            </li>
                                            <li>
                                                <a
                                                    class="vission_trash" wire:click="edit(<?php echo e($eachmodule->id); ?>)">
                                                    <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M7.20605 2.89569C7.73499 4.78252 9.2113 6.25883 11.106 6.79566M8.09815 2.00359L1.87714 8.2246C1.6403 8.46144 1.40346 8.92723 1.35609 9.2667L1.01662 11.643C0.890304 12.5035 1.49819 13.1035 2.35871 12.9851L4.73501 12.6456C5.06659 12.5983 5.53238 12.3614 5.77711 12.1246L11.9981 5.90357C13.0718 4.82989 13.5771 3.58253 11.9981 2.00359C10.4192 0.424659 9.17182 0.929918 8.09815 2.00359Z" stroke="#880505" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                                        </svg>

                                                </a>
                                            </li>
                                            <li>
                                                <a class="trash_only" data-bs-toggle="modal"
                                                    wire:click="deleteConfirmation(<?php echo e($eachmodule->id); ?>)"
                                                    data-bs-target="#DeleteEntry">
                                                    <svg width="14" height="16" viewBox="0 0 14 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M13 3.98659C10.78 3.76659 8.54667 3.65325 6.32 3.65325C5 3.65325 3.68 3.71992 2.36 3.85325L1 3.98659M4.66667 3.31325L4.81333 2.43992C4.92 1.80659 5 1.33325 6.12667 1.33325H7.87333C9 1.33325 9.08667 1.83325 9.18667 2.44659L9.33333 3.31325M11.5667 6.09325L11.1333 12.8066C11.06 13.8533 11 14.6666 9.14 14.6666H4.86C3 14.6666 2.94 13.8533 2.86667 12.8066L2.43333 6.09325M5.88667 10.9999H8.10667M5.33333 8.33325H8.66667" stroke="#880505" stroke-linecap="round" stroke-linejoin="round"/>
                                                        </svg>
                                                </a>
                                            </li>

                                        </ul>

                                    </td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>

                    </table>
                    <?php if($module_list->count() > 0): ?>
                        <div class="pagination_main">
                            <div class="hint-text">Showing <b>
                                    <?php echo e($module_list->perPage() * $module_list->currentPage()); ?></b> out of <b>
                                    <?php echo e($module_list->total()); ?></b> entries</div>
                            <ul class="pagination">
                                <?php echo e($module_list->links()); ?>

                            </ul>
                        </div>
                    <?php endif; ?>


                    <div wire:ignore.self class="modal fade" id="DeleteEntry" tabindex="-1"
                        aria-labelledby="DeleteEntryLabel" aria-hidden="true">
                        <div class="modal-dialog modal-md modal-dialog-centered ">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="DeleteEntryLabel"></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        wire:click="cancel" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="text-center">

                                        <h5>Are you sure to delete?</h5>
                                        <p>Some CTA text here</p>
                                    </div>
                                    <div class="add_cancel" style="float: none; text-align: center;margin: 50px 0;">

                                        <button type="button" class="btn upload_btn" data-bs-dismiss="modal"
                                            wire:click="cancel">Cancel</button>
                                        <button type="submit" class="btn save_item"
                                            wire:click="deleteModuleData">Yes, Delete </button>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div wire:ignore.self class="modal fade" id="viewEntry" tabindex="-1"
                        aria-labelledby="viewEntryLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg modal-dialog-centered ">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="viewEntryLabel">Module</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close" wire:click="cancel"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="col-xl-12 mx-auto">
                                        <h6 class="personal_in"> Details</h6>

                                        <div class="personal_information">
                                            <div class="personal_information_list">
                                                <div class="personal_information_devide">
                                                    <div class="personal_information_title">Title</div>
                                                    <div class="personal_information_des"><?php echo e($name); ?></div>
                                                </div>
                                                <div class="personal_information_devide">
                                                    <div class="personal_information_title">Parent</div>
                                                    <div class="personal_information_des"><?php echo e($parent); ?></div>
                                                </div>
                                                <div class="personal_information_devide">
                                                    <div class="personal_information_title">Url</div>
                                                    <div class="personal_information_des"><?php echo e($url); ?></div>
                                                </div>
                                                <div class="personal_information_devide">
                                                    <div class="personal_information_title">Status</div>
                                                    <div class="personal_information_des">
                                                        <?php if($status == 1): ?>
                                                            <button class="table_btn">Published </button>
                                                        <?php else: ?>
                                                            <button class="table_btn">UnPublished </button>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="personal_information_devide">
                                                    <div class="personal_information_title">Show To Admin</div>
                                                    <div class="personal_information_des">
                                                        <?php if($show_to_admin == 1): ?>
                                                            <button class="table_btn">Show </button>
                                                        <?php else: ?>
                                                            <button class="table_btn">Donot Show </button>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>

                                    </div>
                                    <div class="modal_btns">

                                        <button type="button" class="btn upload_btn" data-bs-dismiss="modal"
                                            wire:click="cancel">Cancel</button>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>

            </div>

        </div>


    </div>

</div>
<?php $__env->startPush('css'); ?>
<style>
.select2-container--open .select2-dropdown{
    top: 12px !important;
}
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <script>
        window.addEventListener('add-new-modal', function() {
            $('#AddEntryModal').modal('show');
        });
        window.addEventListener('show-edit-modal', function() {
            $('#EditEntryModal').modal('show');
        });

        window.addEventListener('close-modal', function() {
            $('#AddEntryModal').modal('hide');
            $('#EditEntryModal').modal('hide');
            $('#DeleteEntry').modal('hide');

        });

        $(document).ready(function() {
            $('#FirstOption').select2({
                placeholder: 'Select an option',
                dropdownParent: $('#AddEntryModal'),
                allowClear: true,

            });

            $(document).on('change', '#FirstOption', function(e) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('parent', e.target.value);
            });

            $('#editFirstOption').select2({
                placeholder: 'Select an option',
                dropdownParent: $('#EditEntryModal'),
                allowClear: true,

            });

            $(document).on('change', '#editFirstOption', function(e) {
                window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('parent', e.target.value);
            });


        });


        window.addEventListener('show-delete-confirmation-modal', event => {
            $('#DeleteEntry').modal('show');
        })
        window.addEventListener('show-view-modal', event => {
            $('#viewEntry').modal('show');
        })


        //this is of edit editFirstOption
        window.addEventListener('select-selected', function(e) {
            $('#editFirstOption').empty().trigger('change');
            $('#editFirstOption').select2({
                data: e.detail.datatest, //but here at loading we got old data, ok wait
                placeholder: 'Select From Dropdown',
                dropdownParent: $('#EditEntryModal'), // ?
                allowClear: true,
            });
            // $('#editFirstOption').val([2,3]); //how to select data with id here
            $('#editFirstOption').val(e.detail.get_id); //how to select data with id here
            $('#editFirstOption').trigger('change'); // Notify any JS components that the value changed
        });

        //this is of edit create data

        window.addEventListener('empty-selected', function(e) {

            $('#FirstOption').select2({
                data: e.detail.datatest,
                placeholder: 'Select From Dropdown',
                dropdownParent: $('#AddEntryModal'),
                allowClear: true,
            });
            $('#FirstOption').val(''); // Select the option with a value of '1' after update i call this
            $('#FirstOption').trigger('change'); // Notify any JS components that the value changed
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH E:\projects\project 11\explorehimalayas\resources\views\livewire\main\module-list.blade.php ENDPATH**/ ?>