<?php $__env->startSection('css'); ?>
<link type="text/css" rel="stylesheet" href="<?php echo e(asset('assets/datatables/css/jquery.dataTables.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript" src="<?php echo e(asset('assets/datatables/js/jquery.dataTables.min.js')); ?>"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('#module_table').DataTable();
    });

</script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content_title'); ?>
<table style="width:100%">
    <tr>
        <th class="headtext">
            Module List
        </th>
        <th class=" float-right">
            <a href="<?php echo e(route('module.create')); ?>" class="btn uniform_use_button float-right">Create
                Module</a>
        </th>
    </tr>
</table>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
            <div class="panel panel-default">
                <div class="panel-body">
                    <?php if(Session::has('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(Session::get('success')); ?>

                    </div>
                    <?php endif; ?>
                    <?php if(Session::has('error')): ?>
                    <div class="alert alert-danger">
                        <?php echo e(Session::get('error')); ?>

                    </div>
                    <?php endif; ?>
                    <table class="table table-bordered" id="module_table">
                        <thead>
                            <tr>
                                <th>SN</th>
                                <th>Name</th>
                                <th>Status</th>
                                <th>URL</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php ($i=1); ?>
                            <?php $__currentLoopData = $module; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>

                                <td><?php echo e($i++); ?></td>
                                <td><?php echo e($m->name); ?></td>
                                <td><?php echo e($m->url); ?></td>
                                <td>
                                    <?php if($m->status==1): ?>
                                    <label class="label label-success">Active</label>
                                    <?php else: ?>
                                    <label class="label label-danger">Inactive</label>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('module.edit',$m)); ?>" class="btn btn-outline-warning" data-toggle="tooltip"
                                        title="Edit Info">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 24 24">
                                        <g fill="none" stroke="#04347a" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2">
                                            <path d="M7 7H6a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2v-1" />
                                            <path d="M20.385 6.585a2.1 2.1 0 0 0-2.97-2.97L9 12v3h3zM16 5l3 3" />
                                        </g>
                                    </svg>
                               </a>

                                    
                                    <form action="<?php echo e(route('module.destroy',$m)); ?>" method="POST"
                                        onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                                        <input type="hidden" name="_method" value="delete">
                                        <?php echo e(csrf_field()); ?>

                                        <button type="submit" class="btn btn-outline-danger" data-toggle="tooltip"
                                            title="Delete Information"><i class="fa fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\projects\project 11\explorehimalayas\Modules\AclManagement\resources\views\module\indexold.blade.php ENDPATH**/ ?>