<?php
use App\Livewire\UserlogManagement;
use Illuminate\Support\Facades\Route;
use App\Livewire\UserlogManagementCustomer;

// Costume route

/**
 * Login Route(s)
 */
Route::get('kss-login', 'App\Http\Controllers\Auth\LoginController@showLoginForm')->name('login');
Route::post('kss-login', 'App\Http\Controllers\Auth\LoginController@login');
Route::post('logout', 'App\Http\Controllers\Auth\LoginController@logout')->name('logout');

/**
 * Register Route(s)
 */
Route::get('kss-register', 'App\Http\Controllers\Auth\RegisterController@showRegistrationForm')->name('register');
Route::post('kss-register', 'App\Http\Controllers\Auth\RegisterController@register');

// Route::get('register', function () {
//     dd("Please Contact Us,Ani kura garamlaa");
// })->name('register');
// Route::post('register', function () {
//     dd("Please Contact Us,Ani kura garamlaa");
// });

/**
 * Password Reset Route(S)
 */
Route::get('password/reset', 'App\Http\Controllers\Auth\ForgotPasswordController@showLinkRequestForm')->name('password.request');
Route::post('password/email', 'App\Http\Controllers\Auth\ForgotPasswordController@sendResetLinkEmail')->name('password.email');
Route::get('password/reset/{token}', 'App\Http\Controllers\Auth\ResetPasswordController@showResetForm')->name('password.reset');
Route::post('password/reset', 'App\Http\Controllers\Auth\ResetPasswordController@reset')->name('password.update');

/**
 * Email Verification Route(s)
 */
Route::get('email/verify', 'App\Http\Controllers\Auth\VerificationController@show')->name('verification.notice');
Route::get('email/verify/{id}', 'App\Http\Controllers\Auth\VerificationController@verify')->name('verification.verify');
Route::get('email/resend', 'App\Http\Controllers\Auth\VerificationController@resend')->name('verification.resend');

// Costume route

// Route::prefix('general')->group(function () {

//     Route::get('login', 'App\Http\Controllers\NormalUserController@showLoginForm')->name('normallogin');
//     Route::post('login', 'App\Http\Controllers\Auth\LoginController@login');
//     Route::post('logout', 'App\Http\Controllers\Auth\LoginController@logout')->name('logout');

//     /**
//      * Register Route(s)
//      */
//     Route::get('register', 'App\Http\Controllers\NormalUserController@showRegistrationForm')->name('normalregister');
//     Route::post('register', 'App\Http\Controllers\NormalUserController@register');

// });
// Auth::routes(['verify' => true]);


// Route::get('{data1?}/{data2?}/{data3?}/{data4?}/{data5?}',function () {
//     return redirect('/');
// });

// Route::get('{path}', 'HomeController@index')->where( 'path' , '([A-z\d\-\/_.]+)?' );

// route for vue

// Route::get('{path}', function () {
//     return redirect('/');
// })->where( 'path' , '([A-z\d\-\/_.]+)?' );

    //Clear Cache facade value:
    Route::get('/clear-cache', function () {
        $exitCode = Artisan::call('cache:clear');
        return '<h1>Cache facade value cleared</h1>';
    });

//Reoptimized class loader:
    Route::get('/optimize', function () {
        $exitCode = Artisan::call('optimize');
        return '<h1>Reoptimized class loader</h1>';
    });

//Route cache:
    Route::get('/route-cache', function () {
        $exitCode = Artisan::call('route:cache');
        return '<h1>Routes cached</h1>';
    });

//Clear Route cache:
    Route::get('/route-clear', function () {
        $exitCode = Artisan::call('route:clear');
        return '<h1>Route cache cleared</h1>';
    });

//Clear View cache:
    Route::get('/view-clear', function () {
        $exitCode = Artisan::call('view:clear');
        return '<h1>View cache cleared</h1>';
    });

//Clear Config cache:
    Route::get('/config-cache', function () {
        $exitCode = Artisan::call('config:cache');
        return '<h1>Clear Config cleared</h1>';
    });

    //clear optimize

    Route::get('/clearall', function () {
        $exitCode = Artisan::call('optimize:clear');
        return '<h1>Cleared optimize File</h1>';
    });

    // livewire route

Route::group(['prefix' => 'backend/v1/', 'middleware' => ['auth','defaultpermission']], function () {
    Route::get('/user-log/{userId}' , UserlogManagement::class)->name('userlog.view');
});

Route::get('/user-log-customer/{userId}' , UserlogManagementCustomer::class)->name('userlogcustomer.view');
