if ('serviceWorker' in navigator) {
  navigator.serviceWorker.register('/serviceworker.js')
  .then(registration => {
    console.log('Service Worker registered with scope:', registration.scope);

    if (!navigator.serviceWorker.controller) {
      // Page is not yet controlled, wait for controllerchange event
      navigator.serviceWorker.addEventListener('controllerchange', () => {
        console.log('Service Worker controller changed - now controlled');
        // Now the page is controlled, you can send messages or show notifications here
        // e.g., showNotification(event);
      });
    } else {
      // Already controlled
      console.log('Service Worker controller already exists');
      // Safe to send messages or show notifications here
      // e.g., showNotification(event);
    }

    return navigator.serviceWorker.ready;
  })
  .then(() => {
    console.log('Service Worker ready');
  })
  .catch(error => {
    console.error('Service Worker registration failed:', error);
  });
}
