const summernoteInit = () => {

    // Define function to open file-manager window
    let lfm = function (options, cb) {
        let route_prefix = (options && options.prefix) ? options.prefix : '/filemanager';
        window.open(route_prefix + '?type=' + options.type || 'file', 'FileManager', 'width=1200,height=900');
        window.SetUrl = cb;
    };

    // Define LFM summernote button
    let LFMButton = function (context) {
        let ui = $.summernote.ui;
        let button = ui.button({
            contents: '<i class="note-icon-picture"></i> ',
            tooltip: 'Insert image with File Manager',
            click: function () {
                lfm({type: 'image', prefix: '/filemanager'}, function (lfmItems, path) {
                    lfmItems.forEach(function (lfmItem) {
                        context.invoke('insertImage', lfmItem.url);
                    });
                });
            },
            container: $('.note-editor.note-frame'),
        });
        return button.render();
    };


    // Define Button
    let InlineNewsButton = function (context) {
        let ui = $.summernote.ui;

        // create button
        let button = ui.button({
            contents: '<a data-bs-toggle="modal" data-bs-target="#summerNoteNewsModal" class="font-size-12 font-weight-bold text-black"><i class="bx bx-news"/> Inline News</a>',
            tooltip: 'Inline News',
            container: $('.note-editor.note-frame'),
            click: function () {
                const node = document.querySelector('.note-editable')
                const cloneNode = node.cloneNode(true)
                document.getElementById('inline-news-modal').append(cloneNode)
                context.invoke('editor.insertText', '');
            }
        });

        return button.render();   // return button as jquery object
    }


    let summernoteEl = $('.my-editor');
    if (summernoteEl.length) {
        summernoteEl.summernote({
            placeholder: 'Please enter your content here.',
            height: 300,
            toolbar: [
                // [groupName, [list of button]]
                ['style', ['bold', 'italic', 'underline', 'fontname', 'clear', 'color']],
                ['font', ['superscript', 'subscript']],
                ['fontsize', ['fontsize', 'hr']],
                ['para', ['style', 'ul', 'ol', 'paragraph']],
                ['height', ['height']],
                ['insert', ['lfm', 'link', 'video', 'table']],
                ['misc', ['fullscreen', 'codeview', 'help']]
            ],
            fontNames: ['Mukta', 'Roboto Light', 'Roboto Regular', 'Roboto Bold', 'Arial', 'Arial Black', 'Comic Sans MS', 'Courier New'],
            fontNamesIgnoreCheck: ['Mukta'],
            fontName: 'Mukta',
            fontSize: '18',
            fontSizeUnits: ['px', 'pt'],
            buttons: {
                lfm: LFMButton, inlineNews: InlineNewsButton
            },
            styleTags: [
                'p', {title: 'Blockquote', tag: 'blockquote', className: 'blockquote', value: 'blockquote'},
                'pre', 'h1', 'h2', 'h3', {title: "Image Caption", tag: "p", value: "p", className: "text-muted font-size-14 font-italic text-underline"},
                {title: "Embedded Video", tag: "div", value: "div", className: "video-wrapper"},],
            shortcuts: true,
            disableGrammar: false,
            callbacks: {
                onImageUpload: function (data) {
                    data.pop();
                }
            }
        });
        $('.note-editable').css({'font-size': '24px', 'text-align': 'justify'});
    }
}




$(document).ready(function () {

    summernoteInit()

})
