<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Builder;
use Modules\AclManagement\Models\Role;
use Modules\UserProfile\Models\UserProfile;
use Illuminate\Database\Eloquent\Casts\Attribute;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'is_admin',
        'is_employee',
        'associated_to',
        'status',
        'provider',
        'provider_id',
        'avatar',
        'type',
        'api_token',
        'email_verified_at',
        'userprofile_id',
        'created_by',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
    public function userprofile(){
        return $this->hasOne(UserProfile::class,'user_id');
    }
    public function company(){
        return $this->belongsTo(UserProfile::class,'userprofile_id');
    }

    public function roles()
    {
        return $this->belongsToMany(Role::class);
    }
    public function scopeActive(Builder $query): void
    {
        $query->where('status', 1);
    }
    protected function Name(): Attribute
    {
        return Attribute::make(
            get: fn (string $value) => ucfirst($value),
            set: fn (string $value) => strtolower($value),
        );
    }
}
