<?php

namespace App\Models;

use Carbon\Carbon;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Modules\GeneralUser\Models\GeneralUser;
use Illuminate\Database\Eloquent\Casts\AsArrayObject;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class LogMessage extends Model
{


    protected $table='logs_messages';

    protected $guarded = [];

    protected $casts = [
        'context' => AsArrayObject::class,
        'extra' => AsArrayObject::class,
    ];
    public function CreatedBy(){
        return $this->belongsTo(User::class,'created_by');
    }

    public function UpdatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function customer(){
        return $this->belongsTo(GeneralUser::class,'customer_id');
    }
    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('F j, Y, g:i a');
        // return Carbon::parse($value)->diffForHumans();
    }
}
