<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use Livewire\WithPagination;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Log;
use Modules\Banner\Entities\Banner;
use App\ServiceContainer\BackendService;
use Modules\Banner\Repositories\BannerInterface;

class BannerComponent extends Component

{
    use WithFileUploads;
    use WithPagination;
    protected $paginationTheme = 'bootstrap';
    protected $banner;
    public $searchTerm='';
    public $id;
    public $image;
    // for multioperation
    public $actionvalue;
    public $checkall;
    public $checkedvalue=[];
    // for multioperation

    public $btn_disabled = 'false';

    public $edit='false';

    public $form=[];

    protected $rules = [
    'form.title'=>'required',
   ];

    public function booted(BannerInterface $banner){
        $this->banner=$banner;
        $this->form['created_by']=auth()->user()->id;
    }
//    for image handeling
public function handleOnChange()
{
 $this->btn_disabled='true';
}
public function openmodal()
{
    $this->dispatch('add-new-modal');


}

     public function updatedImage()
     {
         $path=Banner::FILE_PATH;
         $this->image = BackendService::upload($this->image,$path);
         $this->btn_disabled='false';

     }
//    for image handeling


public function storeData()
 {
    try {
        //code...
        $data =$this->form;

        $this->validate($this->rules);

                        if($this->image){
                        //     $path=banner::FILE_PATH;
                        //      $data['image'] = $this->service->upload($this->image,$path);
                             $data['image'] = $this->image;
                        }
                        $status = Banner::create($data);

                if ($status) {
                    Log::channel('db')->info("Created Banner data of id=".$status->id,$status->toArray());
                   $this->dispatch('toast-message', message: "Information is stored successfully",type:"success");
                   // Session::flash('success', 'Information Stored successfully.');
               } else {
                   $this->dispatch('toast-message', message: "Information Cannot be stored",type:"error");
                   // Session::flash('error', 'Information Cannot be Updated');
               }
    } catch (\Throwable $th) {
        //throw $th;
        flash($th->getMessage())->error();
    }


     $this->resetInputs();
     $this->dispatch("close-modal");
}


public function editdata($id){
 $this->edit="true";

 $data=Banner::find($id)->toArray();
 $this->id=$data['id'];
 $this->form=$data;
 $this->dispatch("show-edit-modal");
}

public function viewData($id){


 $data=Banner::find($id)->toArray();


 $this->form=$data;
 // dd($this->form['id']);
 $this->dispatch("show-view-modal");
}


public function updateData(){
    try {
        //code...
        $data =$this->form;
        $this->validate($this->rules);
        $categories=Banner::where('id',$this->id)->first();
        if($this->image){
            $data['image'] = $this->image;
        }
        $update=$categories->update($data);
        $this->resetInputs();

        $updated_data=Banner::where('id',$this->id)->first();
        if ($update) {
           Log::channel('db')->info("Banner updated data of id=".$this->id,$updated_data->toArray());
           $this->dispatch('toast-message', message: "Information is updated successfully",type:"success");
           // Session::flash('success', 'Information updated successfully.');
       } else {
           $this->dispatch('toast-message', message: "Information Cannot be updated",type:"error");
           // Session::flash('error', 'Information Cannot be Updated');
       }
    } catch (\Throwable $th) {
        //throw $th;
        flash($th->getMessage())->error();
    }


//  Session::flash("success","Entity is edited successfully");
 $this->dispatch("close-modal");
 }

    public function deleteConfirmation($id){
        // $student=Students::where('id',$id)->first();
        $this->id=$id;
        $this->dispatch('show-delete-confirmation-modal');


    }
    public function deleteData(){
        try {

            $data=Banner::where('id',$this->id)->first();
            $delete=$data->delete();
            $this->resetInputs();

            if ($delete) {
              Log::channel('db')->info("Deleted Banner data of id=".$this->id,$data->toArray());
              $this->dispatch('toast-message', message: "Information is deleted successfully",type:"success");
              // Session::flash('success', 'Information deleted successfully.');
          } else {
              $this->dispatch('toast-message', message: "Information Cannot be deleted",type:"error");
              // Session::flash('error', 'Information Cannot be Updated');
          }
          //   Session::flash("success","Information is deleted successfully");

            $this->dispatch("close-modal");
        } catch (\Throwable $th) {
            //throw $th;

        flash($th->getMessage())->error();
        }



    }
    public function cancelAll(){
        $this->resetInputs();
        $this->dispatch("close-modal");

    }

  public function resetInputs(){
    $this->id;
    $this->image;
    $this->checkall=false;
    $this->edit='false';
    $this->form=[];
    $this->checkedvalue = [];

    }

    // for status change

    public function update_status($id)
    {
        $data = Banner::find($id);

        if ($data->status == 0) {
            $data->status = 1;
        } else {
            $data->status = 0;
        }
        $is_success = $data->update();

        if ($is_success) {
            Log::channel('db')->info("Updated Status of id=".$this->id,$data->toArray());
            $this->dispatch('toast-message', message: "Status Updated !!!",type:"success");
        } else {
            $this->dispatch('toast-message', message: "Status Update Failed",type:"error");
        }


    }
        // for status change

    public function render()
    {
        $fdata =  Banner::orderBy('id', 'desc');
        if(!empty($this->searchTerm)){
            $fdata->orWhere('title','like',"%".$this->searchTerm."%");
       }
       $data['banners'] = $fdata->paginate(50);

        // return view('livewire.admin.cake-category-component',$data);
        // return view('livewire.banner-component',$data);
        return view('livewire.admin.banner-component',$data)->layout('layouts.livewire-master');

    }


    // for multi selection operation
    public function multioperation($actionvalue)
    {
        $this->actionvalue=$actionvalue;
        $this->dispatch('show-multidelete-confirmation-modal');
    }

    public function ConfirmMultiOperation(){

        switch ($this->actionvalue) {

            case "delete":

                $is_success= Banner::whereKey($this->checkedvalue)->delete();
                Log::channel('db')->info("Banner  data deleted of id=",$this->checkedvalue);

                break;

            case "active":
                        $new_status = 1;
                        $is_success=Banner::whereKey($this->checkedvalue)->update(['status' => $new_status]);
                        Log::channel('db')->info("Avtive action of id=",$this->checkedvalue);

                break;
            case "inactive":

                        $newstatus = 0;
                        $is_success= Banner::whereKey($this->checkedvalue)->update(['status' => $newstatus]);
                        Log::channel('db')->info("Inactive action for banner  of id=",$this->checkedvalue);


                break;

        }

       $this->resetInputs();
        if ($is_success) {
            $this->dispatch('toast-message', message: "Action Performed !!!",type:"success");
        } else {
            $this->dispatch('toast-message', message: "Action Failed",type:"error");
        }

        $this->dispatch("close-modal");


  }

  public function xxx($id){
    return in_array($id, $this->checkedvalue) ? 'bg-info text-white' : '';
}

  public function checkallvalue(){
      $totalcount=Banner::latest()->get()->pluck(['id'])->toArray();
      if (count($this->checkedvalue)==count($totalcount)) {
        $this->checkedvalue=[];
    }
    else{
        $this->checkedvalue=$totalcount;

    }
}

    // for multi selection operation
}
