<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Symfony\Component\HttpFoundation\Response;

class DefaultPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {


        $roles = Auth::user()->roles;
        // dd($roles);
        $module=[];
        $newarray=[];
        $url=url()->current();
        $route=Route::currentRouteName();
        // dd($url);
        foreach($roles as $r)
        {
            if ($r->name=='superadmin') {
                return $next($request);
            }
            $modules=$r->modules;
            foreach($modules as $m)
            {
               array_push($module,$m->url);
            }

        }
        for($i=0;$i<count($module);$i++)
        {
            if (!in_array($module[$i], $newarray))
        {
            array_push($newarray,$module[$i]);
        }
        }
        // $url=url()->current();
        for($i=0;$i<count($newarray);$i++)
        {
            if( strpos( $route, $newarray[$i] ) !== false) {
            return $next($request);
        }
            if( strpos( $url, $newarray[$i] ) !== false) {
                return $next($request);
            }


        }
        // return redirect()->route('errorpage')->with('error', 'Sorry, you donot have permission to perform this action, Please contact your Admin');

        abort(403, 'Unauthorized action.');


    }
}
