<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Traits\ActivityTraits;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers,ActivityTraits;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        // $this->middleware('guest:generaluser')->except('logout');
    }

    public function login(Request $request)

    {
        // dd("fasd");

        $input = $request->all();



        $this->validate($request, [

            'email' => 'required|email',

            'password' => 'required',

        ]);



//        if(auth()->attempt(array('email' => $input['email'], 'password' => $input['password'])))
            $remember = isset($input['remember']) ? true : false;

        if (auth()->attempt(['email' => $input['email'], 'password' => $input['password'], 'status' => 1], $remember)) {

            $message=$this->LogLocationDetail();
            Log::channel('db')->info("Loggedin",$message);

            // if (auth()->user()->is_admin == 1) {


            //     return redirect()->route('admin.home');

            // }else{

                return redirect()->route('home');

            // }

        }else{

            return redirect()->back()

                ->with('error','Email-Address And Password Are Wrong.');
            // return redirect()->route('login')

            //     ->with('error','Email-Address And Password Are Wrong.');

        }



    }
}
