@extends('layouts.master')
@section('page_title')
User Profile
@endsection
@section('breadcrumb')
@endsection

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">

                <div class="row">
                    <div class="col-xl-6">
                        <div class="mb-3">
                            <label for="projectname" class="form-label"> Name</label>
                            <input type="text" name="name" id="name" class="form-control" value="{{ $user->userprofile->name }}">
                        </div>
                        <div class="mb-3">
                            <label for="companyname" class="form-label">Company Name</label>
                            <input type="text" name="company_name" id="companyname" class="form-control" value="{{ $user->userprofile->company_name }}">
                        </div>
                        <div class="mb-3">
                            <label for="temporary_address" class="form-label">Temporary Address</label>
                            <input type="text" name="t_address" id="companyname" class="form-control" value="{{ $user->userprofile->t_address }}">
                        </div>



                    </div> <!-- end col-->

                    <div class="col-xl-6">
                        <div class="mb-3 mt-3 mt-xl-0">
                            <label for="projectname" class="mb-0">Image</label>
                            {{-- <p class="text-muted font-14">Recommended thumbnail size 800x400 (px).</p> --}}

                            <form action="{{ route('userprofile.update',$user->userprofile->id) }}" enctype="multipart/form-data" method="post" class="dropzone" id="myAwesomeDropzone" data-plugin="dropzone" data-previews-container="#file-previews"
                                data-upload-preview-template="#uploadPreviewTemplate">
                                @method('PUT')
                                @csrf
                                <div class="fallback">
                                    <input name="file" type="file" />
                                </div>
                                {{-- <div class="col-md-6 col-xs-12">
                                    <div class="form-group">
                                        <label>Image :</label>
                                        <input type="file" class="form-control dropify" name="image" value=""
                                            data-default-file="{{ ($user->userprofile->image) ? asset($user->userprofile->image) : '' }}">
                                        @if(isset($user->userprofile->id))
                                            <img src="{{asset($user->userprofile->image)}}" height="100" width="150">
                                        @endif
                                    </div>
                                </div> --}}

                                {{-- <div class="dz-message needsclick">
                                    <i class="h3 text-muted ri-upload-cloud-2-line"></i>
                                    <h4>Drop files here or click to upload.</h4>
                                </div> --}}

                            <!-- Preview -->
                            <div class="dropzone-previews mt-3" id="file-previews"></div>

                            <!-- file preview template -->
                            <div class="d-none" id="uploadPreviewTemplate">
                                <div class="card mt-1 mb-0 shadow-none border">
                                    <div class="p-2">
                                        <div class="row align-items-center">
                                            <div class="col-auto">
                                                <img data-dz-thumbnail src="#" class="avatar-sm rounded bg-light" alt="">
                                            </div>
                                            <div class="col ps-0">
                                                <a href="javascript:void(0);" class="text-muted fw-bold" data-dz-name></a>
                                                <p class="mb-0" data-dz-size></p>
                                            </div>
                                            <div class="col-auto">
                                                <!-- Button -->
                                                <a href="#" class="btn btn-link btn-lg text-muted" data-dz-remove>
                                                    <i class="ri-close-line"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end file preview template -->
                        </div>

                        <!-- Date View -->

                    </div> <!-- end col-->
                </div>
                <!-- end row -->
                <div class="row">


                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="contact">Contact:</label>
                            <input type="text" name="contact" class="form-control"
                                value="{{old('contact',$user->userprofile->contact)}}" required>
                            @if ($errors->has('contact'))
                            <span class="help-block">
                                <strong>{{ $errors->first('contact') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>

                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="p_address"> Permanent Address:</label>
                            <input type="p_address" name="p_address" class="form-control"
                                value="{{old('p_address',$user->userprofile->p_address)}}" required>
                            @if ($errors->has('p_address'))
                            <span class="help-block">
                                <strong>{{ $errors->first('p_address') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="short_description"> Short description:</label>
                            <input type="text" name="short_description" class="form-control"
                                value="{{old('short_description',$user->userprofile->short_description)}}" required>
                            @if ($errors->has('short_description'))
                            <span class="help-block">
                                <strong>{{ $errors->first('short_description') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>



                </div>
                <div class="row">


                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="fb">Facebook:</label>
                            <input type="text" name="fb" class="form-control"
                                value="{{old('fb',$user->userprofile->fb)}}" required>
                            @if ($errors->has('fb'))
                            <span class="help-block">
                                <strong>{{ $errors->first('fb') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>

                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="twitter"> Twitter:</label>
                            <input type="twitter" name="twitter" class="form-control"
                                value="{{old('twitter',$user->userprofile->twitter)}}" required>
                            @if ($errors->has('twitter'))
                            <span class="help-block">
                                <strong>{{ $errors->first('twitter') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="gmail">Gmail:</label>
                            <input type="text" name="gmail" class="form-control"
                                value="{{old('gmail',$user->userprofile->gmail)}}" required>
                            @if ($errors->has('gmail'))
                            <span class="help-block">
                                <strong>{{ $errors->first('gmail') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>



                </div>
                <div class="row">


                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="linkedin">Linkedin:</label>
                            <input type="text" name="linkedin" class="form-control"
                                value="{{old('linkedin',$user->userprofile->linkedin)}}" required>
                            @if ($errors->has('linkedin'))
                            <span class="help-block">
                                <strong>{{ $errors->first('linkedin') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>

                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="youtube"> Youtube:</label>
                            <input type="youtube" name="youtube" class="form-control"
                                value="{{old('youtube',$user->userprofile->youtube)}}" required>
                            @if ($errors->has('youtube'))
                            <span class="help-block">
                                <strong>{{ $errors->first('youtube') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="whatsapp">Whatsapp:</label>
                            <input type="text" name="whatsapp" class="form-control"
                                value="{{old('whatsapp',$user->userprofile->whatsapp)}}" required>
                            @if ($errors->has('whatsapp'))
                            <span class="help-block">
                                <strong>{{ $errors->first('whatsapp') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>



                </div>
                <div class="row">


                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="instagram">Instagram:</label>
                            <input type="text" name="instagram" class="form-control"
                                value="{{old('instagram',$user->userprofile->instagram)}}" required>
                            @if ($errors->has('instagram'))
                            <span class="help-block">
                                <strong>{{ $errors->first('instagram') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>

                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="tiktok"> Tiktok:</label>
                            <input type="tiktok" name="tiktok" class="form-control"
                                value="{{old('tiktok',$user->userprofile->tiktok)}}" required>
                            @if ($errors->has('tiktok'))
                            <span class="help-block">
                                <strong>{{ $errors->first('tiktok') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-4 col-xs-12">
                        <div class="form-group ">
                            <label for="mobile">Mobile:</label>
                            <input type="text" name="mobile" class="form-control"
                                value="{{old('mobile',$user->userprofile->mobile)}}" required>
                            @if ($errors->has('mobile'))
                            <span class="help-block">
                                <strong>{{ $errors->first('mobile') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>
                    <div class="col-md-12 col-xs-12">
                        <div class="form-group ">
                            <label for="mobile">Mobile:</label>
                            <textarea name="description" class="my-editor" id="" cols="30" rows="10"></textarea>
                            @if ($errors->has('mobile'))
                            <span class="help-block">
                                <strong>{{ $errors->first('mobile') }}</strong>
                            </span>
                            @endif
                        </div>
                    </div>



                </div>
                <div class="row" style="padding:10px">
                    <div class="col-md-12">
                        <button class="btn uniform_use_button float-right">Update</button>
                    </div>
                </div>
            </form>



            </div> <!-- end card-body -->
        </div> <!-- end card-->
    </div> <!-- end col-->
</div>
<!-- end row-->
@endsection


