<?php

namespace Modules\UserProfile\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserProfile extends Model
{
    use HasFactory;
    const FILE_PATH='uploads/userprofile';
    protected $table="userprofiles";

    protected $fillable = [
    'company_name',
    'name',
    't_address',
    'email',
    'contact',
    'p_address',
    'mobile',
     'fb',
     'twitter',
     'gmail',
      'linkedin',
      'youtube',
      'whatsapp',
      'instagram',
       'tiktok',
       'short_description',
       'description',
       'user_id',
       'image',



    ];

public function createdBy(){
    return $this->belongsTo(User::class,'created_by');
}
public function updatedBy(){
    return $this->belongsTo(User::class,'updated_by');
}
    protected static function newFactory()
    {
        return \Modules\UserProfile\Database\factories\UserProfileFactory::new();
    }
}
