<?php

namespace Modules\UserProfile\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use App\ServiceContainer\BackendService;
use Modules\UserProfile\Models\UserProfile;

class UserProfileController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $userprofile;

    public function index()
    {
        return view('userprofile::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('userprofile::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show()
    {
        $data['user']=auth()->user();
        return view('userprofile::userprofile.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit()
    {

        $data['user']=auth()->user();
        return view('userprofile::userprofile.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        // dd($request);
        $data=$request->all();
        try {
            if ($request->hasFile('image')) {
                $path=UserProfile::FILE_PATH;
                $data['image']=BackendService::upload($data['image'],$path);
            }
           $update= UserProfile::find($id);
           $update->update($data);
            flash("Information updated successfully")->success();

        } catch (\Throwable $e) {
            //throw $th;
            flash($e->getMessage())->error();
        }
        return redirect()->route('userprofile.show');
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //

    }
}
