<?php

use Illuminate\Support\Facades\Route;
use Modules\UserManagement\Http\Controllers\UserController;
use Modules\UserManagement\Http\Controllers\UserManagementController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::group([], function () {
//     Route::resource('usermanagement', UserManagementController::class)->names('usermanagement');
//     Route::resource('usercontroller', UserController::class)->names('userc');
// });

Route::group(['prefix' => 'backend/v1/', 'middleware' => ['auth','defaultpermission']], function () {
    //for default
        // Route::resource('usermanagement', 'UserManagementController');
        Route::resource('user', UserController::class);
        Route::post('userinactive', [UserController::class,'inactiveindex'])->name('user.inactiveindex');

        // Route::get('userinactive', 'UserController@inactiveindex')->name('user.inactiveindex');
        Route::get('/assignrole/{id}', [UserController::class,'assign'])->name('user.assignrole');
        Route::post('/saveroleuser/{id}', [UserController::class,'assign_role'])->name('user.saveroleuser');
        Route::get('userchangestatus/{id}', [UserController::class,'changestatus'])->name('userchangestatus');
        Route::get('verifyuserstatus/{id}', [UserController::class,'verifyuserstatus'])->name('verifyuserstatus');
        Route::get('verifyuserstatus/{id}', [UserController::class,'verifyuserstatus'])->name('verifyuserstatus');
        Route::get('my-profile/{id}', [UserController::class,'myprofile'])->name('user.myprofile');
        Route::get('user-profile/{id}', [UserController::class,'userprofile'])->name('user.userprofile');

        // Route::get('/assignrole/{id}', 'UserController@assign')->name('user.assignrole');
        // Route::post('/saveroleuser/{id}', 'UserController@assign_role')->name('user.saveroleuser');
        // Route::get('userchangestatus/{id}', 'UserController@changestatus')->name('userchangestatus');
        // Route::get('verifyuserstatus/{id}', 'UserController@verifyuserstatus')->name('verifyuserstatus');
        //for defaulr
        // Route::get('my-profile/{id}', 'UserController@myprofile')->name('user.myprofile');
        // Route::get('user-profile/{id}', 'UserController@userprofile')->name('user.userprofile');


    });
    Route::get('/myedit/{id?}', [UserController::class,'myedit'])->name('user.myedit');
    Route::put('/myupdate/{id?}', [UserController::class,'myupdate'])->name('user.myupdate');
    // Route::get('/myedit/{id?}', 'UserController@myedit')->name('user.myedit'); //to edit password only by user
    // Route::put('/myupdate/{id?}', 'UserController@myupdate')->name('user.myupdate');



    // socialite
    Route::get('auth/{provider}', [UserController::class,'redirect']);
    Route::get('auth/{provider}/callback', [UserController::class,'callback']);
// Route::get('auth/{provider}', 'UserController@redirect');

// Route::get('auth/{provider}/callback', 'UserController@callback');

// socialite

