@extends('layouts.master')

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            User Create
        </th>
        <th class=" float-right">
            <a href="{{route('user.index')}}" class="btn uniform_use_button float-right">User List</a>
        </th>
    </tr>
</table>
@endsection

@section('content')

<form role="form" action="{{route('user.myupdate',$user->id)}}" method="post" enctype="multipart/form-data" class="valid_form">
    {{csrf_field()}}
    <input type="hidden" name="_method" value="PUT">

    <div class="box-body">
        <div class="form-group">
            <label for="name"> Name</label>
        <input type="text" class="form-control" name="name" value="{{old('name',$user->name)}}">
        </div>
        <div class="form-group">
            <label for="email">Email</label>:<p>{{$user->email}}</p>
            <input type="hidden" name="email" value="{{ $user->email }}">
        </div>

        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" name="password" id="password" class="form-control" required>
            @if ($errors->has('password'))
            <span class="help-block">
                <strong>{{ $errors->first('password') }}</strong>
            </span>
            @endif
        </div>
        <div class="form-group">
            <label for="password-confirm">Confirm Password</label>

            <input id="password-confirm" type="password" class="form-control" name="password_confirmation"
                required>
        </div>


        <div class="box-footer">
            <button type="submit" class="btn uniform_use_button">Submit</button>
        </div>
    </div>
</form>

@endsection
