@extends('layouts.backmaster')

@section('title', 'PressRelease')

@section('content_header')
@stop

@section('csssec')
@stop

@section('jssec')
@stop

@section('seccontent')
<div class="container">
    <div class="row">
        <div class="col-md-10">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <a href="{{route('testimonial.index')}}" class="btn btn-outline-primary pull-right"> List</a>
                    <h1>Detail Page</h1>
                </div>

                <div class="panel-body">
                    <table class="table table-bordered ">
                        <tr>
                            <th>Name</th>
                            <td>{{$testimonial->name}}</td>
                        </tr>
                        <tr>
                            <th>Rating</th>
                            <td>{{$testimonial->rating}}</td>
                        </tr>
                        <tr>
                            <th>Message</th>
                            <td>{{$testimonial->message}}</td>
                        </tr>
                        <tr>
                            <th>Sort Order</th>
                            <td>{{$testimonial->sort_order}}</td>
                        </tr>
                        <tr>
                            <th>Image</th>
                            <td>
                                <img src="{{asset($testimonial->image)}}" height="100" width="150">

                            </td>
                        </tr>






                        @if ($testimonial->createdBy)
                        <tr>
                            <th>Created By</th>
                            <td>{{$testimonial->createdBy->name}}</td>
                        </tr>
                        @endif
                        @if ($testimonial->updatedBy)
                        <tr>
                            <th>Updated By</th>
                            <td>{{$testimonial->updatedBy->name}}</td>
                        </tr>

                        @endif



                        <tr>
                            <th>Status</th>
                            <td>
                                @if($testimonial->status==1)
                                <label class="badge badge-success">Active</label>
                                @else
                                <label class="badge badge-danger">Inactive</label>
                                @endif
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <a href="{{route('testimonial.edit', $testimonial)}}" class="btn btn-outline-primary"><i
                                        class="fa fa-pen">&nbsp;&nbsp;&nbsp; Edit</i></a>

                            </td>
                            <td>
                                <form action="{{route('testimonial.destroy', $testimonial->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn btn-outline-danger"><i
                                            class="fa fa-trash">&nbsp;&nbsp;&nbsp; Delete</i></button>
                                </form>

                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
