<?php
namespace Modules\Testimonial\Repositories;

use Modules\Testimonial\Entities\Testimonial;
use Modules\Testimonial\Repositories\TestimonialInterface;
use Modules\Testimonial\Repositories\TestimonialRepository;


class TestimonialRepository implements TestimonialInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = Testimonial::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return Testimonial::find($id);
    }

   public function getList(){
       $result = Testimonial::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return Testimonial::create($data);
    }

    public function update($id,$data){
        $result = Testimonial::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return Testimonial::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . Testimonial::FILE_PATH, $fileName);
        $fileName=Testimonial::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveTestimonial()
    {
       return Testimonial::where('status',1)->get();
    }

}
