<?php

namespace Modules\Testimonial\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Contracts\Support\Renderable;
use Modules\Testimonial\Entities\Testimonial;
use Modules\Testimonial\Repositories\TestimonialInterface;

class TestimonialController extends Controller
{
    protected $testimonial;
    public function __construct(TestimonialInterface $testimonial){
        $this->testimonial=$testimonial;
    }
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['rating'] = $request->get('rating');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['testimonials'] = $this->testimonial->findAll($limit = 50, $filter, $sort);
        $data['testimonials']->appends(['rating' => $filter['rating']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('testimonial::testimonial.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['testimonial']=new Testimonial();
        return view('testimonial::testimonial.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();


        try{
            if($request->hasFile('image')){
                $data['image'] = $this->testimonial->upload($data['image']);
            }
            // if($request->hasFile('logo')){
            //     $data['logo'] = $this->testimonial->upload($data['logo']);
            // }


            $this->testimonial->save($data);
            flash("Testimonial stored successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('testimonial.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['testimonial'] = $this->testimonial->find($id);
        return view('testimonial::testimonial.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['testimonial'] = $this->testimonial->find($id);
        return view('testimonial::testimonial.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->testimonial->upload($data['image']);
            }
            // if($request->hasFile('logo')){
            //     $data['logo'] = $this->testimonial->upload($data['logo']);
            // }
            // $data['category_for']="imageinfo";
            $this->testimonial->update($id,$data);
            flash("Testimonial Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('testimonial.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        try{
            $this->testimonial->delete($id);
            flash("Testimonial  Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('testimonial.index'));
    }
    }

