<?php

namespace Modules\Testimonial\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\Testimonial\Entities\Testimonial;


class Testimonial extends Model
{
    const FILE_PATH='/uploads/testimonial/';
    protected $table='testimonials';
    protected $fillable = [

        'name',
        'rating',
        'image',
        'message',

        'created_by',
        'updated_by',
        'sort_order',

        'status',

    ];


    public function createdBy(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function updatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }
}
