@extends('layouts.backmaster')

@section('title', 'Sarathi Holidays')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
    <table style="width:100%">
        <tr>
            <th class="headtext">
                Slider
            </th>
            <th class="float-right">
                <a href="{{ route('slider.index') }}" class="btn btn-outline-primary pull-right">
                    List</a>
            </th>
        </tr>
    </table>
@endsection

@section('seccontent')
    @if (session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
            <div class="panel panel-default">
                <div class="panel-body">
                    @if (!isset($slider->id))
                        <form method="post" action="{{ route('slider.store') }}" enctype="multipart/form-data"
                            class="valid_form">
                            <input type="hidden" class="form-control" name="created_by" value="{{ Auth::user()->id }}">
                        @else
                            <form method="post" action="{{ route('slider.update', $slider) }}" method="post"
                                enctype="multipart/form-data" class="valid_form">
                                {{-- <input type="hidden" name="_method" value="put"> --}}
                                {{ method_field('PUT') }}

                                <input type="hidden" class="form-control" name="updated_by" value="{{ Auth::user()->id }}">
                                {{-- <input type="hidden" class="form-control" name="created_by" value="{{$slider->created_by}}">
                        --}}
                    @endif
                    {{ csrf_field() }}

                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group ">
                                <label for="title">Title:</label>
                                <input type="text" name="title" class="form-control"
                                    value="{{ old('title', $slider->title) }}" required>
                                @if ($errors->has('title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-6 col-xs-12">
                            <div class="form-group ">
                                <label for="link">Url:</label>
                                <input type="text" name="url" class="form-control"
                                    value="{{ old('url', $slider->url) }}" required>
                                @if ($errors->has('url'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('url') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                    </div>

                    <div class="row">

                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label>Image :</label>
                                <input type="file" class="form-control dropify" name="image" value=""
                                    data-default-file="{{ $slider->image ? asset($slider->image) : '' }}">
                                @if (isset($slider->id))
                                    <img src="{{ asset($slider->image) }}" height="100" width="150">
                                @endif
                            </div>
                        </div>



                    </div>
                    <div class="row">


                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="sort_order"> Sort Order:</label>
                                <input type="number" name="sort_order" class="form-control"
                                    value="{{ old('sort_order', $slider->sort_order) }}" required>
                                @if ($errors->has('sort_order'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sort_order') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                    </div>


                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label for="status">Status:</label><br>
                                <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                <input type="radio" name="status" id="status" value="0"
                                    {{ $slider->status == '0' ? 'checked' : '' }}> Inactive
                            </div>
                        </div>
                    </div>

                    <div class="row" style="padding:10px">
                        <div class="col-md-12">
                            <button class="btn btn-outline-success float-right">Save</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection
