<?php
namespace Modules\Slider\Repositories;

use Modules\Slider\Entities\Slider;
use Modules\Slider\Repositories\SliderInterface;
use Modules\Slider\Repositories\SliderRepository;


class SliderRepository implements SliderInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = Slider::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return Slider::find($id);
    }

   public function getList(){
       $result = Slider::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return Slider::create($data);
    }

    public function update($id,$data){
        $result = Slider::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return Slider::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . Slider::FILE_PATH, $fileName);
        $fileName=Slider::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveSlider()
    {
       return Slider::where('status',1)->get();
    }

}
