<?php

namespace Modules\Slider\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Slider\Entities\Slider;
use Illuminate\Contracts\Support\Renderable;
use Modules\Slider\Repositories\SliderInterface;

class SliderController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $slider;

    public function __construct(SliderInterface $slider)
    {
        $this->slider = $slider;
    }
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['title'] = $request->get('title');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['sliders'] = $this->slider->findAll($limit = 50, $filter, $sort);
        $data['sliders']->appends(['title' => $filter['title']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('slider::slider.index',compact('sort'),$data);
    }


    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['slider']=new Slider();
        return view('slider::slider.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();


        try{
            if($request->hasFile('image')){
                $data['image'] = $this->slider->upload($data['image']);
            }


            $this->slider->save($data);
            flash("Slider stored successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('slider.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['slider'] = $this->slider->find($id);
        return view('slider::slider.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['slider'] = $this->slider->find($id);
        return view('slider::slider.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->slider->upload($data['image']);
            }
            // $data['category_for']="imageinfo";
            $this->slider->update($id,$data);
            flash("Slider  Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('slider.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try{
            $this->slider->delete($id);
            flash("Slider  Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('slider.index'));
    }
}
