<?php

namespace Modules\Slider\Entities;

use App\User;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Slider extends Model
{
    use HasSlug;

    const FILE_PATH='/uploads/slider/';
    protected $table='sliders';
    protected $fillable = [
        'title',
        'image',
        'url',
        'status',
        'sort_order',
        'created_by',
        'updated_by',


    ];
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

    public function createdBy(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function updatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }
}
