<?php
namespace Modules\PageModule\Repositories;

use Modules\PageModule\Entities\PageModule;
use Modules\PageModule\Repositories\PageModuleInterface;


class PageModuleRepository implements PageModuleInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {
        $result = PageModule::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');
            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return PageModule::find($id);
    }

   public function getList(){
       $result = PageModule::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return PageModule::create($data);
    }

    public function update($id,$data){
        $result = PageModule::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return PageModule::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . PageModule::FILE_PATH, $fileName);
        $fileName=PageModule::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveBanner()
    {
       return PageModule::where('status',1)->get();
    }

}
