<?php

namespace Modules\PageModule\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\PageModule\Entities\PageModule;
use Modules\PageModule\Repositories\PageModuleInterface;

class PageModuleController extends Controller
{
    protected $pageModule;

    public function __construct(PageModuleInterface $pageModule)
    {
        $this->pageModule = $pageModule;
    }

    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['title'] = $request->get('title');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['pagemodules'] = $this->pageModule->findAll($limit = 50, $filter, $sort);
        $data['pagemodules']->appends(['title' => $filter['title']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('pagemodule::pagemodule.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {

            $data['is_edit'] = false;
            $data['pagemodule']=new PageModule();
            return view('pagemodule::pagemodule.create',$data);

//        return view('pagemodule::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();
        // dd($data);

        try{
            if($request->hasFile('image')){
                $data['image'] = $this->pageModule->upload($data['image']);
            }
//            if($request->hasFile('citizenship')){
//                $data['citizenship'] = $this->pageModule->upload($data['citizenship']);
//            }

            $this->pageModule->save($data);
            flash("Information Saved Successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('pagemodule.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('pagemodule::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['pagemodule'] = $this->pageModule->find($id);
        return view('pagemodule::pagemodule.create',$data);
//        return view('pagemodule::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->pageModule->upload($data['image']);
            }
            $data['category_for']="imageinfo";
            $this->pageModule->update($id,$data);
            flash("Information Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('pagemodule.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        try{
            $this->pageModule->delete($id);
            flash("Information Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('pagemodule.index'));
    }
}
