@extends('layouts.backmaster')

@section('title', 'PressRelease')

@section('content_header')
@stop

@section('csssec')
@stop

@section('jssec')
@stop

@section('seccontent')
<div class="container">
    <div class="row">
        <div class="col-md-10">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <a href="{{route('packagemanagement.index')}}" class="btn btn-outline-primary pull-right"> List</a>
                    <h1>Detail Page</h1>
                </div>

                <div class="panel-body">
                    <table class="table table-bordered ">
                        <tr>
                            <th>Title</th>
                            <td>{{$packagemanagement->title}}</td>
                        </tr>
                        <tr>
                            <th>Meta Title</th>
                            <td>{{$packagemanagement->meta_title}}</td>
                        </tr>
                        <tr>
                            <th>Highlighted Text</th>
                            <td>{{$packagemanagement->highlighted_text}}</td>
                        </tr>
                        <tr>
                            <th>Meta Description</th>
                            <td>{{$packagemanagement->meta_description}}</td>
                        </tr>
                        {{-- <tr>
                            <th>Sort Order</th>
                            <td>{{$packagemanagement->sort_order}}</td>
                        </tr> --}}
                        <tr>
                            <th>Parent</th>
                            <td>{{$packagemanagement->parent}}</td>
                        </tr>
                        <tr>
                            <th>Image</th>
                            <td>
                                <img src="{{asset($packagemanagement->image)}}" height="100" width="150">

                            </td>
                        </tr>
                        <tr>
                            <th>Show in Home</th>
                            <td>


                                    @if($packagemanagement->show_home==1)
                                    <label class="badge badge-success">Yes</label>
                                    @else
                                    <label class="badge badge-danger">No</label>
                                    @endif

                            </td>
                        </tr>

                        <tr>
                            <th>Show In Nav</th>


                                <td>


                                    @if($packagemanagement->show_in_nav==1)
                                    <label class="badge badge-success">Yes</label>
                                    @else
                                    <label class="badge badge-danger">No</label>
                                    @endif

                            </td>
                            
                        </tr>
                        @if ($packagemanagement->createdBy)
                        <tr>
                            <th>Created By</th>
                            <td>{{$packagemanagement->createdBy->name}}</td>
                        </tr>
                        @endif
                        @if ($packagemanagement->updatedBy)
                        <tr>
                            <th>Updated By</th>
                            <td>{{$packagemanagement->updatedBy->name}}</td>
                        </tr>

                        @endif



                        <tr>
                            <th>Status</th>
                            <td>
                                @if($packagemanagement->status==1)
                                <label class="badge badge-success">Active</label>
                                @else
                                <label class="badge badge-danger">Inactive</label>
                                @endif
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <a href="{{route('packagemanagement.edit', $packagemanagement)}}" class="btn btn-outline-primary"><i
                                        class="fa fa-pen">&nbsp;&nbsp;&nbsp; Edit</i></a>

                            </td>
                            <td>
                                <form action="{{route('packagemanagement.destroy', $packagemanagement->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn btn-outline-danger"><i
                                            class="fa fa-trash">&nbsp;&nbsp;&nbsp; Delete</i></button>
                                </form>

                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
