@extends('layouts.backmaster')

@section('title', 'Sarathi Holidays')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
    <table style="width:100%">
        <tr>
            <th class="headtext">
                Package Management
            </th>
            <th class="float-right">
                <a href="{{ route('packagemanagement.index') }}" class="btn btn-outline-primary pull-right">
                    List</a>
            </th>
        </tr>
    </table>
@endsection

@section('seccontent')
    @if (session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
            <div class="panel panel-default">
                <div class="panel-body">
                    @if (!isset($packagemanagement->id))
                        <form method="post" action="{{ route('packagemanagement.store') }}" enctype="multipart/form-data"
                            class="valid_form">
                            <input type="hidden" class="form-control" name="created_by" value="{{ Auth::user()->id }}">
                        @else
                            <form method="post" action="{{ route('packagemanagement.update', $packagemanagement) }}"
                                method="post" enctype="multipart/form-data" class="valid_form">
                                {{-- <input type="hidden" name="_method" value="put"> --}}
                                {{ method_field('PUT') }}

                                <input type="hidden" class="form-control" name="updated_by" value="{{ Auth::user()->id }}">
                                {{-- <input type="hidden" class="form-control" name="created_by" value="{{$packagemanagement->created_by}}">
                        --}}
                    @endif
                    {{ csrf_field() }}

                    <div class="row">
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="title">Title:</label>
                                <input type="text" name="title" class="form-control"
                                    value="{{ old('title', $packagemanagement->title) }}" required>
                                @if ($errors->has('title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="highlighted_text">Highlighted Text:</label>
                                <input type="text" name="highlighted_text" class="form-control"
                                    value="{{ old('highlighted_text', $packagemanagement->highlighted_text) }}" required>
                                @if ($errors->has('highlighted_text'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('highlighted_text') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="title">Parent:</label>
                                <select name="parent" class="form-control myselect">
                                    <option value=""></option>
                                    @foreach ($parentPackage as $item)
                                        <option value="{{ $item->id }}"
                                            {{ $packagemanagement->parent == $item->id ? 'selected' : '' }}>
                                            {{ $item->title }}
                                        </option>
                                    @endforeach
                                </select>
                                @if ($errors->has('parent'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('parent') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                    </div>


                    <div class="row">
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="meta_title">Meta Title:</label>
                                <input type="text" name="meta_title" class="form-control"
                                    value="{{ old('meta_title', $packagemanagement->meta_title) }}" required>
                                @if ($errors->has('meta_title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('meta_title') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="meta_description"> Meta Description:</label> <br>
                                <textarea name="meta_description" id="">{{ old('meta_description', $packagemanagement->meta_description) }}</textarea>
                                {{-- <input type="text" name="link" class="form-control"
                                    value="{{old('link',$packagemanagement->link)}}" required> --}}
                                @if ($errors->has('meta_description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('meta_description') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-4 col-xs-12">
                            <div class="form-group">
                                <label>Image :</label>
                                <input type="file" class="form-control dropify" name="image" value=""
                                    data-default-file="{{ $packagemanagement->image ? asset($packagemanagement->image) : '' }}">
                                @if (isset($packagemanagement->id))
                                    {{-- <img src="{{ asset($packagemanagement->image) }}" height="100" width="150"> --}}
                                @endif
                            </div>
                        </div>

                    </div>

                    <div class="row">
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group">
                                <label for="status">Show in Nav:</label><br>
                                <input type="radio" name="show_in_nav" id="status" value="1" checked> Show <br>
                                <input type="radio" name="show_in_nav" id="status" value="0"
                                    {{ $packagemanagement->show_in_nav == '0' ? 'checked' : '' }}> Do not Show
                            </div>
                        </div>

                        <div class="col-md-4 col-xs-12">
                            <div class="form-group">
                                <label for="status">Show in Home:</label><br>
                                <input type="radio" name="show_home" id="status" value="1" checked> Show <br>
                                <input type="radio" name="show_home" id="status" value="0"
                                    {{ $packagemanagement->show_home == '0' ? 'checked' : '' }}> Do not Show
                            </div>
                        </div>

                        <div class="col-md-4 col-xs-12">
                            <div class="form-group">
                                <label for="status">Status:</label><br>
                                <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                <input type="radio" name="status" id="status" value="0"
                                    {{ $packagemanagement->status == '0' ? 'checked' : '' }}> Inactive
                            </div>
                        </div>
                    </div>

                    <div class="row" style="padding:10px">
                        <div class="col-md-12">
                            <button class="btn btn-outline-success float-right">Save</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection
