<?php

namespace Modules\PackageManagement\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Contracts\Support\Renderable;
use Modules\PackageManagement\Entities\PackageManagement;
use Modules\PackageManagement\Repositories\PackageManagementInterface;

class PackageManagementController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $packagemanagement;

    public function __construct(PackageManagementInterface $packagemanagement)
    {
        $this->packagemanagement = $packagemanagement;
    }
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['title'] = $request->get('title');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['packagemanagements'] = $this->packagemanagement->findAll($limit = 50, $filter, $sort);
        $data['packagemanagements']->appends(['title' => $filter['title']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('packagemanagement::packagemanagement.index',compact('sort'),$data);

    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['packagemanagement']=new PackageManagement();
        $data['parentPackage']=PackageManagement::where('status',1)->get();
        return view('packagemanagement::packagemanagement.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();


        try{
            if($request->hasFile('image')){
                $data['image'] = $this->packagemanagement->upload($data['image']);
            }


            $this->packagemanagement->save($data);
            flash("Package Management stored successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('packagemanagement.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
    
        $data['packagemanagement'] = $this->packagemanagement->find($id);
        
        return view('packagemanagement::packagemanagement.show',$data);

    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['packagemanagement'] = $this->packagemanagement->find($id);
        $data['parentPackage']=PackageManagement::where('status',1)->get();
        return view('packagemanagement::packagemanagement.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //

        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->packagemanagement->upload($data['image']);
            }
            $data['category_for']="imageinfo";
            $this->packagemanagement->update($id,$data);
            flash("Package Management Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('packagemanagement.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try{
            $this->packagemanagement->delete($id);
            flash("Package   Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('packagemanagement.index'));

    }
}
