<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePackageMgmtsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('package_mgmts', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->text('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->string('slug')->nullable();
            $table->string('highlighted_text')->nullable();
            $table->string('show_home')->nullable();
            $table->string('show_in_nav')->nullable();
            $table->integer('parent')->nullable();
            $table->string('image')->nullable();


           $table->integer('sort_order')->nullable();


           $table->boolean('status')->default(1);

           $table->bigInteger('created_by')->unsigned()->nullable();
           $table->bigInteger('updated_by')->unsigned()->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('package_mgmts');
    }
}
