

@extends('layouts.backmaster')

@section('title', 'Imageinfo')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
           Package Gallary
        </th>
        <th class="float-right">
            <a href="{{route('package.index')}}" class="btn btn-primary pull-right">
                List</a>
        </th>
    </tr>
</table>
@endsection

@section('seccontent')


<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">
                @if(!isset($packagegallery->id))
                <form method="post" action="{{route('packagegallery.store')}}" enctype="multipart/form-data" class="valid_form">
                    @else
                    <form method="post" action="{{route('packagegallery.update',$packagegallery)}}" method="post"
                        enctype="multipart/form-data" class="valid_form">
                        {{method_field('PUT')}}
                        @endif
                        {{csrf_field()}}

                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group ">
                                    <label for="title">Title:</label>
                                    <input type="text" name="title" class="form-control"
                                        value="{{old('title',$packagegallery->title)}}" required>
                                    @if ($errors->has('title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>

                        </div>
                        <div class="row">
                            @if ($is_edit==1)
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Image :</label>
                                    <input type="file" class="form-control dropify" name="image" value=""
                                        data-default-file="{{ ($packagegallery->image) ? asset($packagegallery->image) : '' }}">

                                </div>
                            </div>


                            @else
                            <input type="hidden" name="package_id" value="{{$package->id}}">

                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Image/Images :</label>
                                    <input type="file" class="form-control" name="image[]" value="" multiple
                                        data-default-file="{{ ($packagegallery->image) ? asset($packagegallery->image) : '' }}">
                                </div>
                            </div>
                            @endif

                        </div>
                        {{-- <div class="row">
                            <div class="col-md-12 col-xs-12">
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea type="text" name="description" class="form-control my-editor"
                                        required>{{old('description',$package->description)}}</textarea>
                                </div>
                            </div>
                        </div> --}}
                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label for="status">Status:</label><br>
                                    <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                    <input type="radio" name="status" id="status" value="0" {{$packagegallery->status=='0'?'checked':''}}> Inactive
                                </div>
                            </div>
                        </div>
                        {{-- <div class="row">
                            <div class="col-md-6">
                              <h2 class="mt-4">Standalone Image Button</h2>
                              <div class="input-group">
                                <span class="input-group-btn">
                                  <a id="lfm" data-input="thumbnail" data-preview="holder" class="btn btn-primary text-white">
                                    <i class="fa fa-picture-o"></i> Choose
                                  </a>
                                </span>
                                <input id="thumbnail" class="form-control" type="text" name="filepath">
                              </div>
                              <div id="holder" style="margin-top:15px;max-height:100px;"></div>

                            </div>
                          </div> --}}

                          <div class="row" style="padding:10px">
                            <div class="col-md-12">
                                <button class="btn btn-success float-right">Save</button>
                            </div>
                        </div>
                    </form>
            </div>
        </div>
    </div>
</div>

@endsection
