<?php
namespace Modules\PackageGallery\Repositories;

use Modules\PackageGallery\Entities\PackageGallery;
use Modules\PackageGallery\Repositories\PackageGalleryInterface;
use Modules\PackageGallery\Repositories\PackageGalleryRepository;


class PackageGalleryRepository implements PackageGalleryInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = PackageGallery::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return PackageGallery::find($id);
    }

   public function getList(){
       $result = PackageGallery::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return PackageGallery::create($data);
    }

    public function update($id,$data){
        $result = PackageGallery::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return PackageGallery::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . PackageGallery::FILE_PATH, $fileName);
        $fileName=PackageGallery::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActivePackageGallery()
    {
       return PackageGallery::where('status',1)->get();
    }

    public function unlinkImage($path){
        if(file_exists($path)){
            @unlink($path);
        }
        return true;
    }

}
