@extends('layouts.backmaster')

@section('title', 'PressRelease')

@section('content_header')
@stop

@section('csssec')
@stop

@section('jssec')
@stop

@section('seccontent')
<div class="container">
    <div class="row">
        <div class="col-md-10">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <a href="{{route('package.index')}}" class="btn btn-outline-primary pull-right"> List</a>
                    <h1>Detail Page</h1>
                </div>

                <div class="panel-body">
                    <table class="table table-bordered ">
                        <tr>
                            <th>Title</th>
                            <td>{{$package->title}}</td>
                        </tr>
                        <tr>
                            <th>Meta Title</th>
                            <td>{{$package->meta_title}}</td>
                        </tr>
                        <tr>
                            <th>Meta Description</th>
                            <td>{!! $package->meta_description !!}</td>
                        </tr>
                        <tr>
                            <th>Map</th>
                            <td>{{$package->map}}</td>
                        </tr>
                        <tr>
                            <th>Currency  Type</th>
                            <td>{{$package->currency_type}}</td>
                        </tr>
                        <tr>
                            <th>Duration</th>
                            <td>{{$package->duration}}</td>
                        </tr>
                        <tr>
                            <th>Starting Point</th>
                            <td>{{$package->starting_point}}</td>
                        </tr>
                        <tr>
                            <th>Ending Point</th>
                            <td>{{$package->ending_point}}</td>
                        </tr>
                        <tr>
                            <th>Itinerary</th>
                            <td>{!! $package->itinerary !!}</td>
                        </tr>
                        <tr>
                            <th>Includes</th>
                            <td>{!! $package->includes !!}</td>
                        </tr>

                        <tr>
                            <th>Sort Order</th>
                            <td>{{$package->sort_order}}</td>
                        </tr>
                        <tr>
                            <th>Fact</th>
                            <td>{!! $package->fact !!}</td>
                        </tr>
                        <tr>
                            <th>Image</th>
                            <td>
                                <img src="{{asset($package->image)}}" height="100" width="150">

                            </td>
                        </tr>
                        <tr>
                            <th> Gallery Image</th>
                            <td>
                                @if ($package->packagegallery()->count()>0)
                                    @foreach ($package->packagegallery as $item)

                                    <img src="{{asset($item->image)}}" height="100" width="150">
                                    @endforeach

                                @endif

                            </td>
                        </tr>
                        <tr>
                            <th>Description</th>
                            <td>{!!$package->description!!}</td>
                        </tr>

                        <tr>
                            <th>Short Description</th>
                            <td>{{$package->short_description}}</td>
                        </tr>
                        @if ($package->createdBy)
                        <tr>
                            <th>Created By</th>
                            <td>{{$package->createdBy->name}}</td>
                        </tr>
                        @endif
                        @if ($package->updatedBy)
                        <tr>
                            <th>Updated By</th>
                            <td>{{$package->updatedBy->name}}</td>
                        </tr>

                        @endif
                        
                        <tr>
                            <th> Is Featured</th>
                            <td>
                                @if($package->is_featured==1)
                                <label class="badge badge-success">Yes</label>
                                @else
                                <label class="badge badge-danger">No</label>
                                @endif
                            </td>
                        </tr>



                        <tr>
                            <th>Status</th>
                            <td>
                                @if($package->status==1)
                                <label class="badge badge-success">Active</label>
                                @else
                                <label class="badge badge-danger">Inactive</label>
                                @endif
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <a href="{{route('package.edit', $package)}}" class="btn btn-outline-primary"><i
                                        class="fa fa-pen">&nbsp;&nbsp;&nbsp; Edit</i></a>

                            </td>
                            <td>
                                <form action="{{route('package.destroy', $package->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn btn-outline-danger"><i
                                            class="fa fa-trash">&nbsp;&nbsp;&nbsp; Delete</i></button>
                                </form>

                            </td>
                        </tr>
                    </table>
                    <table class="table table-bordered">

                        <h3> Package Management</h3>


                        <tr>
                            <td>      Packagemanagement=@foreach ($package->packageMgmt as $item)
                                {{$item->title}}</td>
                        </tr>

                    </table>


                   @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
