<?php
namespace Modules\Package\Repositories;

use Modules\Package\Entities\Package;
use Modules\Package\Repositories\PackageInterface;
use Modules\Package\Repositories\PackageRepository;


class PackageRepository implements PackageInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = Package::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return Package::find($id);
    }

   public function getList(){
       $result = Package::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return Package::create($data);
    }

    public function update($id,$data){
        $result = Package::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return Package::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . Package::FILE_PATH, $fileName);
        $fileName=Package::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActivePackage()
    {
       return Package::where('status',1)->get();
    }

}
