<?php

namespace Modules\Package\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\OurTeam\Entities\OurTeam;
use Modules\Package\Entities\Package;
use Illuminate\Contracts\Support\Renderable;
use Modules\Package\Repositories\PackageInterface;
use Modules\PackageGallery\Entities\PackageGallery;
use Modules\PackageManagement\Entities\PackageManagement;

class PackageController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $package;
    public function __construct(PackageInterface $package){
        $this->package = $package;
    }
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['title'] = $request->get('title');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['packages'] = $this->package->findAll($limit = 50, $filter, $sort);
        $data['packages']->appends(['title' => $filter['title']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('package::package.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['package']=new Package();
        $data['packagemanagement']=PackageManagement::latest()->where('status',1)->get();
        $data['ourteam']=OurTeam::latest()->where('status',1)->get();

        return view('package::package.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();



        try{
            if($request->hasFile('image')){
                $data['image'] = $this->package->upload($data['image']);
            }
            if($request->hasFile('detail_image')){
                $data['detail_image'] = $this->package->upload($data['detail_image']);
            }




            $store= $this->package->save($data);
            
            $store->packageMgmt()->attach($request->package_mgmt_id);
            $store->packageGuide()->attach($request->ourteam_id);

            if($request->hasFile('package_gallary')){
                foreach ($request->file('package_gallary') as $item) {
                    $image = $this->package->upload($item);
                    PackageGallery::create([
                       'package_id'=>$store->id,
                        'image'=>$image,
                    ]);
                }
            }

            flash("Package  stored successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('package.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['package'] = $this->package->find($id);
        return view('package::package.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;

        $data['package'] = $this->package->find($id);
        // dd($data['package']->packageMgmt->pluck('id')->toArray());
        $data['packagemanagement']=PackageManagement::latest()->where('status',1)->get();
        $data['ourteam']=OurTeam::latest()->where('status',1)->get();

        return view('package::package.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->package->upload($data['image']);
            }
            if($request->hasFile('detail_image')){
                $data['detail_image'] = $this->package->upload($data['detail_image']);
            }
            // $data['category_for']="imageinfo";

            $this->package->update($id,$data);
            $update=$this->package->find($id);
           $update->packageMgmt()->sync($request->package_mgmt_id);
           $update->packageGuide()->sync($request->ourteam_id);
           if($request->hasFile('package_gallary')){
            foreach ($request->file('package_gallary') as $item) {
                $image = $this->package->upload($item);
                PackageGallery::create([
                   'package_id'=>$id,
                    'image'=>$image,
                ]);
            }
        }
            flash("Package  Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('package.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try{
            $this->package->delete($id);
            flash("Package   Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('package.index'));
    }
}
