<?php

namespace Modules\Package\Entities;

use App\User;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Modules\OurTeam\Entities\OurTeam;
use Modules\Package\Entities\Package;
use Illuminate\Database\Eloquent\Model;
use Modules\PackageGallery\Entities\PackageGallery;
use Modules\BookingManagement\Entities\BookingManagement;
use Modules\PackageManagement\Entities\PackageManagement;


class Package extends Model
{
    use HasSlug;

    const FILE_PATH='/uploads/package/';
    protected $table='packages';
    protected $fillable = [
        'title',
        'meta_title',
        'meta_description',
        'is_featured',
        'slug',
         'short_description',
        'image',
        'detail_image',
        'currency_type',
        'created_by',
        'updated_by',
        'sort_order',
        'description',
        'starting_point',
        'ending_point',
        'itinerary',
        'includes',
        'excludes',
        'fact',
        'map','testimonial',

        'duration',
        'status',

    ];
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

    public function createdBy(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function updatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }

    public function packageMgmt()
    {
        return $this->belongsToMany(PackageManagement::class, 'package_mgmt_packages','package_id','package_mgmt_id');
    }
    public function packageGuide()
    {
        return $this->belongsToMany(OurTeam::class, 'package_guides','package_id','ourteam_id');
    }
    public function package(){
        return $this->belongsTo(BookingManagement::class,'package_id');
    }
    public function packagegallery(){
        return $this->hasMany(PackageGallery::class,'package_id');
    }
}
