<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePackagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->text('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->string('slug')->nullable();
            $table->text('short_description')->nullable();
            $table->string('duration')->nullable();
            $table->string('starting_point')->nullable();
            $table->string('ending_point')->nullable();
            $table->longText('description')->nullable();
            $table->string('currency_type')->nullable();
            $table->string('detail_image')->nullable();
            $table->text('map')->nullable();
            $table->longText('fact')->nullable();
            $table->longText('itinerary')->nullable();
            $table->longText('includes')->nullable();
            $table->longText('excludes')->nullable();
            $table->string('image')->nullable();


           $table->integer('sort_order')->nullable();


           $table->string('is_featured')->nullable();
           $table->boolean('status')->default(1);

           $table->bigInteger('created_by')->unsigned()->nullable();
           $table->bigInteger('updated_by')->unsigned()->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('packages');
    }
}
