<?php
namespace Modules\OurTeam\Repositories;

use Modules\OurTeam\Entities\OurTeam;
use Modules\OurTeam\Repositories\OurTeamInterface;
use Modules\OurTeam\Repositories\OurTeamRepository;


class OurTeamRepository implements OurTeamInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = OurTeam::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return OurTeam::find($id);
    }

   public function getList(){
       $result = OurTeam::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return OurTeam::create($data);
    }

    public function update($id,$data){
        $result = OurTeam::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return OurTeam::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . OurTeam::FILE_PATH, $fileName);
        $fileName=OurTeam::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveOurTeam()
    {
       return OurTeam::where('status',1)->get();
    }

}
