<?php

namespace Modules\OurTeam\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\OurTeam\Entities\OurTeam;
use Illuminate\Contracts\Support\Renderable;
use Modules\OurTeam\Repositories\OurTeamInterface;

class OurTeamController extends Controller
{
    protected $ourteam;
    public function __construct(OurTeamInterface $ourteam){
        $this->ourteam=$ourteam;
    }
    public function index(Request $request)
    {
     $filter = $request->all();
        $filter['title'] = $request->get('title');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['ourteams'] = $this->ourteam->findAll($limit = 50, $filter, $sort);
        $data['ourteams']->appends(['title' => $filter['title']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('ourteam::ourteam.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['ourteam']=new OurTeam();
        return view('ourteam::ourteam.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();


        try{
            if($request->hasFile('image')){
                $data['image'] = $this->ourteam->upload($data['image']);
            }



            $this->ourteam->save($data);
            flash("Our Team stored successfully")->success();
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('ourteam.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['ourteam'] = $this->ourteam->find($id);
        return view('ourteam::ourteam.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['ourteam'] = $this->ourteam->find($id);
        return view('ourteam::ourteam.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->ourteam->upload($data['image']);
            }
            // if($request->hasFile('logo')){
            //     $data['logo'] = $this->ourteam->upload($data['logo']);
            // }
            // $data['category_for']="imageinfo";
            $this->ourteam->update($id,$data);
            flash("Our Team Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('ourteam.index'));

    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try{
            $this->ourteam->delete($id);
            flash("Our Team  Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('ourteam.index'));
    }
    }

