<?php

namespace Modules\NepalDivision\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\Support\Renderable;
use Modules\NepalDivision\Entities\NepalDivision;

class NepalDivisionController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('nepaldivision::nepaldivision.index');
    }
    public function getprovince()
    {
        return NepalDivision::distinct('province')->pluck('province');
    }
    public function getdistrict(Request $request)
    {
        $province=$request->province;
        return NepalDivision::where('province',$province)->distinct('district')->pluck('district');

    }
    public function getlocal(Request $request)
    {
        $district=$request->district;
        $province=$request->province;
        return NepalDivision::where('district',$district)->where('province',$province)->pluck('local_bodies');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('nepaldivision::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('nepaldivision::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('nepaldivision::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
