@extends('layouts.backmaster')

@section('title', 'Sarathi Holidays')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
    <table style="width:100%">
        <tr>
            <th class="headtext">
                Inquiry
            </th>
            <th class="float-right">
                <a href="{{ route('inquiry.index') }}" class="btn btn-outline-primary pull-right">
                    List</a>
            </th>
        </tr>
    </table>
@endsection

@section('seccontent')
    @if (session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
            <div class="panel panel-default">
                <div class="panel-body">
                    @if (!isset($inquiry->id))
                        <form method="post" action="{{ route('inquiry.store') }}" enctype="multipart/form-data"
                            class="valid_form">
                            <input type="hidden" class="form-control" name="created_by" value="{{ Auth::user()->id }}">
                        @else
                            <form method="post" action="{{ route('inquiry.update', $inquiry) }}" method="post"
                                enctype="multipart/form-data" class="valid_form">
                                {{-- <input type="hidden" name="_method" value="put"> --}}
                                {{ method_field('PUT') }}

                                <input type="hidden" class="form-control" name="updated_by" value="{{ Auth::user()->id }}">
                                {{-- <input type="hidden" class="form-control" name="created_by" value="{{$inquiry->created_by}}">
                        --}}
                    @endif
                    {{ csrf_field() }}

                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group ">
                                <label for="name">Name:</label>
                                <input type="text" name="name" class="form-control"
                                    value="{{ old('name', $inquiry->name) }}" required>
                                @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="phone"> Phone:</label>
                                <input type="text" name="phone" class="form-control"
                                    value="{{ old('phone', $inquiry->phone) }}" required>
                                @if ($errors->has('phone'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                        {{--
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Image :</label>
                                    <input type="file" class="form-control dropify" name="image" value=""
                                        data-default-file="{{ ($inquiry->image) ? asset($inquiry->image) : '' }}">
                                    @if (isset($inquiry->id))
                                        <img src="{{asset($inquiry->image)}}" height="100" width="150">
                                    @endif
                                 </div>
                            </div> --}}


                    </div>




                    <div class="row">

                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="email"> Email:</label>
                                <input type="email" name="email" class="form-control"
                                    value="{{ old('email', $inquiry->email) }}" required>
                                @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="message"> Message:</label>
                                <input type="text" name="message" class="form-control"
                                    value="{{ old('message', $inquiry->message) }}" required>
                                @if ($errors->has('message'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('message') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="sort_order"> Sort Order:</label>
                                <input type="number" name="sort_order" class="form-control"
                                    value="{{ old('sort_order', $inquiry->sort_order) }}" required>
                                @if ($errors->has('sort_order'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sort_order') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label for="status">Status:</label><br>
                                <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                <input type="radio" name="status" id="status" value="0"
                                    {{ $inquiry->status == '0' ? 'checked' : '' }}> Inactive
                            </div>
                        </div>
                    </div>

                    <div class="row" style="padding:10px">
                        <div class="col-md-12">
                            <button class="btn btn-outline-success float-right">Save</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection
