<?php

namespace Modules\Inquiry\Http\Controllers;

use App\Mail\InqueryMail;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Mail;
use Modules\Inquiry\Entities\Inquiry;
use Illuminate\Contracts\Support\Renderable;
use Modules\Inquiry\Repositories\InquiryInterface;

class InquiryController extends Controller
{
    protected $inquiry;
    public function __construct(InquiryInterface $inquiry){
        $this->inquiry=$inquiry;
    }
    public function index(Request $request)
    {
        $filter = $request->all();
        $filter['name'] = $request->get('name');
        $sort['by'] = $request->get('key', 'sort_order');
        $sort['sort'] = $request->get('sort', 'ASC');
        $data['inquiries'] = $this->inquiry->findAll($limit = 50, $filter, $sort);
        $data['inquiries']->appends(['name' => $filter['name']]);

        $sort = ($sort['sort'] == 'ASC') ? 'DESC' : 'ASC';
        return view('inquiry::inquiry.index',compact('sort'),$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        $data['is_edit'] = false;
        $data['inquiry']=new Inquiry();
        return view('inquiry::inquiry.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
        $data = $request->all();



        try{
            if($request->hasFile('image')){
                $data['image'] = $this->inquiry->upload($data['image']);
            }
            // if($request->hasFile('logo')){
            //     $data['logo'] = $this->inquiry->upload($data['logo']);
            // }


            $stored=$this->inquiry->save($data);
            if($stored)
            {

                Mail::to($stored->email)->send(new InqueryMail($stored));
                Mail::send('mail.contact', ['contact' => $stored], function ($mail) use ($stored) {
                    $mail->from($stored->email, $stored->name);
                    $mail->to('info@sarathiholidays.com.np')->subject('Enquiry');
                });

                //     Mail::send('mail.contact', ['contact' => $status], function ($mail) use ($status) {
                //     $mail->from('info@naturalyogainnepal.com', 'info');
                //     $mail->to('naturalyogainm@gmail.com')->subject('Enquiry');
                // });

            }

            flash("Thank you for your concern , We will Contact You Soon")->success();
            // toast('Thank you for your concern , We will Contact You Soon','success');
        }catch(\Throwable  $e){
            flash($e->getMessage())->error();
            // toast($e->getMessage(),'error');
        }

        return redirect()->back();
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        $data['inquiry'] = $this->inquiry->find($id);
        return view('inquiry::inquiry.show',$data);
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit'] = true;
        $data['inquiry'] = $this->inquiry->find($id);
        return view('inquiry::inquiry.create',$data);
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
        $data = $request->all();
        try{

            if($request->hasFile('image')){
                $data['image'] = $this->inquiry->upload($data['image']);
            }
            // if($request->hasFile('logo')){
            //     $data['logo'] = $this->inquiry->upload($data['logo']);
            // }
            // $data['category_for']="imageinfo";
            $this->inquiry->update($id,$data);
            flash("Inquiry Updated Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }

        return redirect(route('inquiry.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
        try{
            $this->inquiry->delete($id);
            flash("Inquiry  Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect(route('inquiry.index'));
    }
    }

