

@extends('layouts.backmaster')

@section('title', 'Imageinfo')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            Imageinfo
        </th>
        <th class="float-right">
            <a href="{{route('imageinfo.index')}}" class="btn btn-primary pull-right">
                List</a>
        </th>
    </tr>
</table>
@endsection

@section('seccontent')


<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">
                @if(!isset($imagegallery->id))
                <form method="post" action="{{route('imagegallery.store')}}" enctype="multipart/form-data" class="valid_form">
                    <input type="hidden" class="form-control" name="created_by" value="{{Auth::user()->id}}">

                    @else
                    <form method="post" action="{{route('imagegallery.update',$imagegallery)}}" method="post"
                        enctype="multipart/form-data" class="valid_form">
                        {{-- <input type="hidden" name="_method" value="put"> --}}
                        {{method_field('PUT')}}

                        <input type="hidden" class="form-control" name="updated_by" value="{{Auth::user()->id}}">
                        {{-- <input type="hidden" class="form-control" name="created_by" value="{{$imagegallery->created_by}}">
                        --}}
                        @endif
                        {{csrf_field()}}

                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group ">
                                    <label for="title">Title:</label>
                                    <input type="text" name="title" class="form-control"
                                        value="{{old('title',$imageinfo->title)}}" required>
                                    @if ($errors->has('title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            {{-- <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="category">Category:</label>
                                    <input type="category" name="category" class="form-control"
                                        value="{{old('category',$imagegallery->category)}}" required>
                                    @if ($errors->has('category'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('category') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div> --}}
                        </div>
                        <div class="row">
                            {{-- {{$is_edit}} --}}
                            @if ($is_edit==1)
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Image :</label>
                                    <input type="file" class="form-control dropify" name="image" value=""
                                        data-default-file="{{ ($imagegallery->image) ? asset($imagegallery->image) : '' }}">

                                </div>
                            </div>


                            @else
                            <input type="hidden" name="item_id" value="{{$imageinfo->id}}">

                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Image/Images :</label>
                                    <input type="file" class="form-control" name="image[]" value="" multiple
                                        data-default-file="{{ ($imagegallery->image) ? asset($imagegallery->image) : '' }}">
                                </div>
                            </div>
                            @endif

                        </div>
                        <div class="row">
                            <div class="col-md-12 col-xs-12">
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea type="text" name="description" class="form-control my-editor"
                                        required>{{old('description',$imageinfo->description)}}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label for="status">Status:</label><br>
                                    <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                    <input type="radio" name="status" id="status" value="0" {{$imagegallery->status=='0'?'checked':''}}> Inactive
                                </div>
                            </div>
                        </div>
                        {{-- <div class="row">
                            <div class="col-md-6">
                              <h2 class="mt-4">Standalone Image Button</h2>
                              <div class="input-group">
                                <span class="input-group-btn">
                                  <a id="lfm" data-input="thumbnail" data-preview="holder" class="btn btn-primary text-white">
                                    <i class="fa fa-picture-o"></i> Choose
                                  </a>
                                </span>
                                <input id="thumbnail" class="form-control" type="text" name="filepath">
                              </div>
                              <div id="holder" style="margin-top:15px;max-height:100px;"></div>

                            </div>
                          </div> --}}

                          <div class="row" style="padding:10px">
                            <div class="col-md-12">
                                <button class="btn btn-success float-right">Save</button>
                            </div>
                        </div>
                    </form>
            </div>
        </div>
    </div>
</div>

@endsection
