<?php

namespace Modules\ImageGallery\Http\Controllers;

use ZipArchive;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use App\Repositories\WatermarkInterface;
use Modules\Imageinfo\Entities\Imageinfo;
use Illuminate\Contracts\Support\Renderable;
use Modules\ImageGallery\Entities\ImageGallery;
use Modules\Imageinfo\Repositories\ImageinfoInterface;
use Modules\ImageGallery\Repositories\ImageGalleryInterface;

class ImageGalleryController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $imageinfoInterface;
    protected $imagegalleryInterface;
    protected $backendInterface;

    public function __construct(
        ImageinfoInterface $imageinfoInterface,
        ImageGalleryInterface $imagegalleryInterface,
        WatermarkInterface $backendInterface

        )
    {
        $this->imageinfoInterface = $imageinfoInterface;
        $this->imagegalleryInterface = $imagegalleryInterface;
        $this->backendInterface = $backendInterface;

    }
    public function index(Request $request)
    {
        $id=$request->imageinfo_id;
         $data['imagegallery'] = $this->imagegalleryInterface->findGallery($id,'imageinfo');
         $data['imageinfo_id']=$id;
         return view('imagegallery::imagegallery.index',$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create(Request $request)
    {
        // dd($request);
        $data['imagegallery']=new ImageGallery();
        $data['is_edit']=0;
        $data['imageinfo_id']=$request->imageinfo_id;
        $data['imageinfo']=$this->imageinfoInterface->find($request->imageinfo_id);
        // dd($data);

        // return view('imageinfo::imageinfo.create',$data);
        return view('imagegallery::imagegallery.create',$data);


        // return view('imagegallery::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();
        // dd($data);

        try{

            if($request->hasFile('image')){
                foreach($request->file('image') as $file)
            {
                $data['image'] = $this->imagegalleryInterface->upload($file);
                $data['category']='imageinfo';
                // $data['item_id']=$storedinfo->id;
                // $this->imagegalleryInterface->save($data);
                if ($data['image']) {
                    # code...
                    $this->backendInterface->TextWatermark($data['image']);
                }
                $result=$this->imagegalleryInterface->save($data);



                       # code...


            }

            }
            Session::flash('success', 'Information Added successfully.');


        }catch(\Throwable  $e){
            Session::flash('error', $e->getMessage());

        }
        return redirect(route('imageinfo.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        // dd($id);
        $data['imagegallery'] = $this->imagegalleryInterface->findGallery($id,'imageinfo');
        // dd($data);
        // return view('imagegallery::index',$data);
        return view('imagegallery::imagegallery.index',$data);
        // return view('imagegallery::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit']=1;
        $data['imagegallery'] = $this->imagegalleryInterface->find($id);
        $data['imageinfo'] = $this->imagegalleryInterface->find($id);

        return view('imagegallery::imagegallery.create',$data);
        // return view('imagegallery::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        // dd($id);
        $data = $request->all();

        try{


            // if($request->hasFile('image')){
            //     $data['image'] = $this->imageinfoInterface->upload($data['image']);
            // }
            if($request->hasFile('image')){

                $data['image'] = $this->imagegalleryInterface->upload($data['image']);
                $data['category']='imageinfo';
                // $this->imagegalleryInterface->update($data);
                if ($data['image']) {

                    $this->backendInterface->TextWatermark($data['image']);

                       # code...
                   }

            }
            $this->imagegalleryInterface->update($id,$data);




            flash("Information Updated Successfully")->success();

        }catch(\Throwable $e){
            flash($e->getMessage())->error();

        }

        return redirect(route('imageinfo.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        try{
            $data=$this->imagegalleryInterface->find($id);
            $path=$data->image;
            $deleteStatus=$this->imagegalleryInterface->delete($id);
            if ($deleteStatus) {
                # code...
                $this->imagegalleryInterface->unlinkImage($path);
            }

            flash("Information Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect()->back();
    }
    public function downloadgallery($id=null)
    {
        // dd($id);
        $data=$this->imagegalleryInterface->find($id);
        // $info = $this->imageinfoInterface->find($id);

        $imagegallery = $this->imagegalleryInterface->findGallery($id,'imageinfo');
        $files=[];
        foreach($imagegallery as $image){
            $path=$image->image;
            array_push($files,$path);

        }
        // dd($files);

        // $image1 = "http://cdn.screenrant.com/wp-content/uploads/Darth-Vader-voiced-by-Arnold-Schwarzenegger.jpg";
        // $image2 = "http://cdn.screenrant.com/wp-content/uploads/Star-Wars-Logo-Art.jpg";

        // $files = array($image1, $image2);

        $tmpFile = tempnam('/tmp', '');

        $zip = new ZipArchive;
        $zip->open($tmpFile, ZipArchive::CREATE);
        foreach ($files as $file) {
            // dd($file);
            // download file
            $fileContent = file_get_contents($file);

            $zip->addFromString(basename($file), $fileContent);
        }
        $zip->close();


        header('Content-Type: application/zip');
        header('Content-disposition: attachment; filename=file.zip');
        header('Content-Length: ' . filesize($tmpFile));
        readfile($tmpFile);

        unlink($tmpFile);


    }
}
