@extends('layouts.backmaster')

@section('title', 'PressRelease')

@section('content_header')
@stop

@section('csssec')
@stop

@section('jssec')
@stop

@section('seccontent')
<div class="container">
    <div class="row">
        <div class="col-md-10">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <a href="{{route('highlights.index')}}" class="btn btn-outline-primary pull-right"> List</a>
                    <h1>Detail Page</h1>
                </div>

                <div class="panel-body">
                    <table class="table table-bordered ">
                        <tr>
                            <th>Title</th>
                            <td>{{$highlights->title}}</td>
                        </tr>
                        <tr>
                            <th>Link</th>
                            <td>{{$highlights->link}}</td>
                        </tr>

                        <tr>
                            <th>Sort Order</th>
                            <td>{{$highlights->sort_order}}</td>
                        </tr>
                        <tr>
                            <th>Description</th>
                            <td>{!!$highlights->description!!}</td>
                        </tr>
                        <tr>
                            <th>Short Description</th>
                            <td>{{$highlights->short_description}}</td>
                        </tr>
                        <tr>
                            <th>Image</th>
                            <td>
                                <img src="{{asset($highlights->image)}}" height="100" width="150">

                            </td>
                        </tr>






                        @if ($highlights->createdBy)
                        <tr>
                            <th>Created By</th>
                            <td>{{$highlights->createdBy->name}}</td>
                        </tr>
                        @endif
                        @if ($highlights->updatedBy)
                        <tr>
                            <th>Updated By</th>
                            <td>{{$highlights->updatedBy->name}}</td>
                        </tr>

                        @endif



                        <tr>
                            <th>Status</th>
                            <td>
                                @if($highlights->status==1)
                                <label class="badge badge-success">Active</label>
                                @else
                                <label class="badge badge-danger">Inactive</label>
                                @endif
                            </td>
                        </tr>

                        <tr>
                            <td>
                                <a href="{{route('highlights.edit', $highlights)}}" class="btn btn-outline-primary"><i
                                        class="fa fa-pen">&nbsp;&nbsp;&nbsp; Edit</i></a>

                            </td>
                            <td>
                                <form action="{{route('highlights.destroy', $highlights->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn btn-outline-danger"><i
                                            class="fa fa-trash">&nbsp;&nbsp;&nbsp; Delete</i></button>
                                </form>

                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
