<?php

namespace Modules\Highlights\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Highlights extends Model
{
    const FILE_PATH='/uploads/highlights/';
    protected $table='highlights';
    protected $fillable = [

         'title',
        'image',

        'short_description',
        'description',
        'link',

        'created_by',
        'updated_by',
        'sort_order',

        'status',

    ];


    public function createdBy(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function updatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }
}
