@extends('layouts.master')


@section('content')
    <div class="referrel_section">
        <div class="referal_first">

            <div class="referal_title">
                <div class="page_name">
                    Profile & Preferences
                </div>


                <nav aria-label="breadcrumb" class="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Profile & Preferences </li>
                    </ol>
                </nav>
            </div>

            {{-- @include('admintemplate.includes.tutorial') --}}

            <!-- Button trigger modal -->
        </div>
        <div class="referal_first">
            <div class="referal_title">

                <div class="go_back_btn">

                    <a href="{{ route('generaluser.index') }}" class="go_back"> <img
                            src="{{ asset('newpanel/icons/goback-btn.png') }}" alt=""></a>
                </div>
            </div>
            <div class="referal_right">
                @if (auth()->guard('generaluser')->check()&&auth()->guard('generaluser')->user()->id==$user->id)
                <a class="btn repost_request" href="{{ route('generaluser.myedit') }}">
                    <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7.20605 2.89569C7.73499 4.78252 9.2113 6.25883 11.106 6.79566M8.09815 2.00359L1.87714 8.2246C1.6403 8.46144 1.40346 8.92723 1.35609 9.2667L1.01662 11.643C0.890304 12.5035 1.49819 13.1035 2.35871 12.9851L4.73501 12.6456C5.06659 12.5983 5.53238 12.3614 5.77711 12.1246L11.9981 5.90357C13.0718 4.82989 13.5771 3.58253 11.9981 2.00359C10.4192 0.424659 9.17182 0.929918 8.09815 2.00359Z" stroke="#880505" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    Edit</a>
                @endif
                {{-- <a class="btn repost_request"><img src="{{ asset('admintemplate/icons/printer.png') }}" alt="">
                    Print </a> --}}
            </div>
        </div>
        <div class="referal_first user_info_pro">
            <div class="profile">
                <div class="name_vari">

                    <div class="start_name">
                        {{ substr($user->name, 0, 1) }}
                    </div>
                    <div class="varified">
                        <img src="{{ asset('newpanel/icons/tick-circle.png') }}" alt="">
                        @if ($user->status == 1)
                            Verified
                        @else
                            Unverified
                        @endif
                    </div>
                </div>
                <div class="right_vari">

                    <h6 class="profile_name">{{ $user->name }}</h6>
                    <h6 class="email_id">{{ $user->email }}</h6>

                </div>
            </div>
            {{-- <div class="logout">
                <a href="#" data-bs-toggle="modal" data-bs-target="#DeleteEntry">
                    Log Out
                </a>

            </div> --}}

            <div class="modal fade" id="DeleteEntry" tabindex="-1" aria-labelledby="DeleteEntryLabel" aria-hidden="true">
                <div class="modal-dialog modal-md modal-dialog-centered ">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="DeleteEntryLabel">Logging out of System ?</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">

                            <div class="text-center delete_icons">
                                <img src="{{ asset('admintemplate/icons/delete.png') }}" alt="">
                                <div class="oh_no">
                                    Oh no !
                                </div>
                                <p>You are about to logout, Are you sure this is what you want?</p>
                            </div>
                            <div class="add_cancel" style="float: none; text-align: center;margin: 50px 0;">

                                <button type="button" class="btn cancel_delete" data-bs-dismiss="modal">Cancel</button>
                                <a class="btn delete_entry" href="{{ route('logout') }}" style="color: black"
                                    class="hide"
                                    onclick="event.preventDefault();
                                        document.getElementById('logout-form').submit();">
                                    Logout
                                </a>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST"
                                    style="display: none;">
                                    @csrf
                                </form>

                            </div>

                        </div>

                    </div>
                </div>
            </div>

        </div>

        <div class="blog_studymaterials">
                           @include('layouts.partials.error')


            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                <li class="nav-item" role="presentation">
                    <a class="nav-link active" id="pills-User-Information-tab" data-bs-toggle="pill"
                        data-bs-target="#pills-User-Information" type="button" role="tab"
                        aria-controls="pills-User-Information" aria-selected="true">User Information</a>
                </li>
                @if (auth()->guard('generaluser')->check()&&auth()->guard('generaluser')->user()->id==$user->id)

                <li class="nav-item" role="presentation">
                    <a   href="{{ route('generaluser.change.password') }}" class="nav-link"
                        type="button" >Password Management</a>

                    {{-- <a class="nav-link" id="password-management-tab" data-bs-toggle="pill"
                        data-bs-target="#password-management" type="button" role="tab"
                        aria-controls="password-management" aria-selected="false">Password Management</a> --}}
                </li>
                @endif



                {{-- <li class="nav-item" role="presentation">
                    <a class="nav-link" id="pills-Billings-Plan-tab" data-bs-toggle="pill"
                        data-bs-target="#pills-Billings-Plan" type="button" role="tab"
                        aria-controls="pills-Billings-Plan" aria-selected="false">Billings & Plan</a>
                </li> --}}
                <li class="nav-item" role="presentation">
                    {{-- <a   href="#" class="nav-link"
                        type="button" >Activity
                        Logs</a> --}}
                    <a   href="{{ route('userlogcustomer.view',$user->id) }}" class="nav-link"
                        type="button" >Activity
                        Logs</a>

                    {{-- <a   href="{{ route('userlog.view',$user->id) }}" class="nav-link" id="pills-Acitivity-tab" data-bs-toggle="pill" data-bs-target="#pills-Acitivity"
                        type="button" role="tab" aria-controls="pills-Acitivity" aria-selected="false">Activity
                        Logs</a> --}}
                </li>


            </ul>
            <div class="tab-content" id="pills-tabContent">
                <div class="tab-pane fade show active" id="pills-User-Information" role="tabpanel"
                    aria-labelledby="pills-User-Information-tab">
                    <div class="row">
                        <div class="col-md-8 mx-auto">
                            <div class="user_information">
                                {{-- <div class="name_for_name">
                                    <div class="name">
                                        User Status
                                    </div>
                                    <div class="name_des">
                                        @if ($user->is_suspend == 0 && $user->is_restrict == 0)
                                            <button class="btn greeny_btn">Onboarded</button>
                                        @elseif ($user->is_suspend == 1)
                                            <button class="btn light_pending_btn">Suspended</button>
                                        @elseif ($user->is_restrict == 1)
                                            <button class="btn red_btn">Restricted</button>
                                        @endif
                                    </div>
                                </div> --}}
                                <div class="name_for_name">
                                    <div class="name">
                                        Name
                                    </div>
                                    <div class="name_des">
                                        {{ $user->name }}
                                    </div>
                                </div>
                                <div class="name_for_name">
                                    <div class="name">
                                        Email
                                    </div>
                                    <div class="name_des">


                                        {{ $user->email }}
                                        @if (auth()->guard('generaluser')->check()&& auth()->guard('generaluser')->user()->id==$user->id)

                                        @if (auth()->guard('generaluser')->user()->email_verified_at)
                                        <p class="green_verify">Verified</p>
                                        @else
                                        <a class="color_s" href="{{ route('generaluser_verification.notice') }}">!Verify Email</a>
                                        @endif
                                        @else
                                        @if ($user->email_verified_at)
                                        <p class="green_verify">Verified</p>
                                        @else
                                        !Unverified
                                        @endif
                                        @endif
                                    </div>
                                </div>

                                <div class="name_for_name">
                                    <div class="name">
                                        Mobile
                                    </div>
                                    <div class="name_des">
                                        {{ $user->mobile }}
                                        @if (auth()->guard('generaluser')->check()&& auth()->guard('generaluser')->user()->id==$user->id)

                                        @if ($user->mobile_verified_at)
                                        <p class="green_verify">Verified</p>
                                        @else
                                        <a class="color_s" href="{{ route('generaluser.otpverification', 'sendotp') }}">!Verify Mobile</a>
                                        @endif
                                        @else
                                        @if ($user->mobile_verified_at)
                                        <p class="green_verify">Verified</p>
                                        @else
                                        !Unverified
                                        @endif
                                        @endif
                                    </div>
                                </div>


                                {{-- <div class="name_for_name">
                                    <div class="name">
                                        Assigned Role
                                    </div>
                                    <div class="name_des">
                                        @foreach ($user->roles as $item)
                                            {{ $item->label }},&nbsp;
                                        @endforeach
                                    </div>
                                </div> --}}
                            </div>
                        </div>
                    </div>
                </div>

                {{-- <div class="tab-pane fade" id="password-management" role="tabpanel"
                    aria-labelledby="password-management-tab">
                    <div class="row">
                        <div class="col-md-8 mx-auto">
                            <div class="user_information">

                                <div class="name_for_name">
                                    <div class="name">
                                        Business Name
                                    </div>
                                    <div class="name_des">
                                        {{ $user_profile->name_of_business }}
                                    </div>
                                </div>
                                <div class="name_for_name">
                                    <div class="name">
                                        Registered PAN No.
                                    </div>
                                    <div class="name_des">
                                        {{ $user_profile->pan_no }}
                                    </div>
                                </div>
                                <div class="name_for_name">
                                    <div class="name">
                                        PAN Certificate Image
                                    </div>
                                    <div class="name_des">
                                        @if ($user_profile->pan)
                                            <img src="{{ asset($user_profile->pan) }}" alt="">
                                            <a type="button" href="{{ $user_profile->pan }}" target="_blank"
                                                class="btn info_btn">
                                                Click to view
                                            </a>
                                        @else
                                            Not Uploaded Yet
                                        @endif
                                    </div>
                                </div>
                                <div class="name_for_name">
                                    <div class="name">
                                        Registered on VAT?
                                    </div>
                                    <div class="name_des">
                                        {{ $user_profile->vat_registered == 'registered' ? 'VAT Certificate Image' : '  PAN Certificate Image' }}
                                    </div>
                                </div>
                                <div class="name_for_name">
                                    <div class="name">
                                        Entity Type
                                    </div>
                                    <div class="name_des">
                                        {{ $user->entity_type }}
                                    </div>
                                </div>


                                <div class="name_for_name">
                                    <div class="name">
                                        Business Type
                                    </div>
                                    <div class="name_des">
                                        {{ $user->business_type }}
                                    </div>
                                </div>
                                <div class="name_for_name">
                                    <div class="name">
                                        Registered Address
                                    </div>
                                    <div class="name_des">
                                        {{ $user->authorized_location }}
                                    </div>
                                </div>
                                <div class="name_for_name">
                                    <div class="name">
                                        Business Email
                                    </div>
                                    <div class="name_des">
                                        {{ $user->business_email }}
                                    </div>
                                </div>
                                <div class="name_for_name">
                                    <div class="name">
                                        Business Contact Number
                                    </div>
                                    <div class="name_des">
                                        {{ $user->mobile }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> --}}




            </div>
        </div>
    </div>
@endsection
