<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('generalusers', function (Blueprint $table) {
            $table->id();
              $table->string('name');
            $table->string('email')->nullable();
            $table->string('mobile')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->timestamp('mobile_verified_at')->nullable();
            $table->string('mobile_token')->nullable();
            $table->integer('status')->default(1);
            $table->string('provider_id')->nullable();
            $table->string('provider')->nullable();
            $table->text('avatar')->nullable();
            $table->string('user_type')->nullable();
            $table->boolean('is_generaluseradmin')->nullable();
            $table->boolean('is_supplier')->nullable();
            $table->string('password')->nullable();
            $table->text('api_token')->nullable();
            $table->rememberToken();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('generalusers');
    }
};
