<?php

namespace Modules\GeneralUser\Http\Controllers;

use App\Rules\ReCaptcha;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Traits\ActivityTraits;

use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Session;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Facades\Validator;
use Modules\GeneralUser\Models\GeneralUser;
use Illuminate\Contracts\Support\Renderable;
use Modules\GeneralUser\Http\Requests\LoginFormRequest;

class AuthController extends Controller
{
    use ActivityTraits;


    public function showloginform()
    {
        // dd(auth()->guard('generaluser')->check());
        //guard admins means admin
        if (auth()->guard('generaluser')->check()) {
            // $userType = auth()->guard('generaluser')->user()->user_type;

            // if ((auth()->guard('generaluser')->user()->user_type == 'customer') ) {
            //     return redirect()->intended(route('frontend.index'));

            // }
            // return redirect('/');

            return redirect()->route('frontend.index');
        }

        return view('generaluser::auth.login');
        // return view('generaluser::auth.loginreg');

    }

    public function authenticate(LoginFormRequest $request)
    {
        // dd($request);
        // $this->validator($request->all())->validate();

        $input = $request->only('email', 'password', 'remember');
        $remember = isset($input['remember']) ? true : false;
        if (strpos($input['email'], '@') !== false) {

            // $input['email']=$request->mobile_email;

            if (auth()->guard('generaluser')->attempt(['email' => $input['email'], 'password' => $input['password'], 'status' => 1], $remember)) {
                // return redirect('/');
                $message=$this->LogLocationDetail();
                Log::channel('db')->info("Loggedin",$message);

                return redirect()->route('frontend.index');
            }else{

                return redirect()->back()

                    ->with('error','Email/Phone or Password Incorrect !!');

            }

        }
        else{
            if (auth()->guard('generaluser')->attempt(['mobile' => $input['email'], 'password' => $input['password'], 'status' => 1], $remember)) {

                // return redirect('/');
                $message=$this->LogLocationDetail();
                Log::channel('db')->info("Loggedin",$message);

                return redirect()->route('frontend.index');

                // return redirect()->intended('/');

    //            $userType = auth()->guard('generaluser')->user()->generaluser_type;
    //
    //            if (in_array($userType, ['super_admin', 'admin'])) {
    //                return redirect()->intended(route('dashboard'));
    //
    //            } elseif (auth()->guard('generaluser')->user()->generaluser_type == 'vendor') {
    //                return redirect()->intended(route('vendor.dashboard'));
    //
    //            } else {
    //                return redirect()->intended(url('/'));
    //
    //            }

            } else {
                Session::flash('error', 'Email/Phone or Password Incorrect !!');


                // flash("The email or password is invalid")->error();
                // return view('user::auth.login');
                return redirect()->back();
            }
        }


    }

    public function logout()
    {
        // dd(auth()->user()->id);
        if (auth()->guard('generaluser')->check()){
            Auth::guard('generaluser')->logout();
            // auth()->guard('generaluser')->user()->logout();
        }
        // else
        // {

        //     auth()->logout();
        // }
        // auth()->guard('admins')->user();
        return redirect('/');
    }

        // socialite use

public function redirect($provider)
{
    return Socialite::driver($provider)->redirect();
}



public function Callback($provider)
{

    $userSocial = Socialite::driver($provider)->stateless()->user();
    // $userSocial = Socialite::driver($provider)->user();

    $users = GeneralUser::where(['email' => $userSocial->getEmail()])->first();
    if ($users) {
        auth()->guard('generaluser')->login($users);
        return redirect('/');
    } else {
        $udata=[
            'name' => $userSocial->getName(),
            'email' => $userSocial->getEmail(),
            'provider_id' => $userSocial->getId(),
            'provider' => $provider,
            'mobile' => rand(1000000000, 9999999999),
            'avatar' => $userSocial->getAvatar(),
        ];
        $user = GeneralUser::create($udata);
        $user->generaluserProfile()->create($udata);
        auth()->guard('generaluser')->login($user);

        return redirect('/');
        // return view('frontend::customer.dashboard');

    }
}

// socialite use
}
